/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.stoex;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CompareOperations implements Enumerator
{
    GREATER(0, "GREATER", "GREATER"),
    EQUALS(1, "EQUALS", "EQUALS"),
    LESS(2, "LESS", "LESS"),
    NOTEQUAL(3, "NOTEQUAL", "NOTEQUAL"),
    LESSEQUAL(4, "LESSEQUAL", "LESSEQUAL"),
    GREATEREQUAL(5, "GREATEREQUAL", "GREATEREQUAL");

    public static final String copyright = "Copyright 2007-2009, SDQ, IPD, U Karlsruhe";
    public static final int GREATER_VALUE = 0;
    public static final int EQUALS_VALUE = 1;
    public static final int LESS_VALUE = 2;
    public static final int NOTEQUAL_VALUE = 3;
    public static final int LESSEQUAL_VALUE = 4;
    public static final int GREATEREQUAL_VALUE = 5;
    private static final CompareOperations[] VALUES_ARRAY;
    public static final List<CompareOperations> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CompareOperations[]{GREATER, EQUALS, LESS, NOTEQUAL, LESSEQUAL, GREATEREQUAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CompareOperations get(String literal) {
        CompareOperations[] compareOperationsArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            CompareOperations result = compareOperationsArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static CompareOperations getByName(String name) {
        CompareOperations[] compareOperationsArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            CompareOperations result = compareOperationsArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static CompareOperations get(int value) {
        switch (value) {
            case 0: {
                return GREATER;
            }
            case 1: {
                return EQUALS;
            }
            case 2: {
                return LESS;
            }
            case 3: {
                return NOTEQUAL;
            }
            case 4: {
                return LESSEQUAL;
            }
            case 5: {
                return GREATEREQUAL;
            }
        }
        return null;
    }

    private CompareOperations(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

