/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.stoex;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ProductOperations implements Enumerator
{
    MULT(0, "MULT", "MULT"),
    DIV(1, "DIV", "DIV"),
    MOD(2, "MOD", "MOD");

    public static final String copyright = "Copyright 2007-2009, SDQ, IPD, U Karlsruhe";
    public static final int MULT_VALUE = 0;
    public static final int DIV_VALUE = 1;
    public static final int MOD_VALUE = 2;
    private static final ProductOperations[] VALUES_ARRAY;
    public static final List<ProductOperations> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ProductOperations[]{MULT, DIV, MOD};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ProductOperations get(String literal) {
        ProductOperations[] productOperationsArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            ProductOperations result = productOperationsArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static ProductOperations getByName(String name) {
        ProductOperations[] productOperationsArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            ProductOperations result = productOperationsArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static ProductOperations get(int value) {
        switch (value) {
            case 0: {
                return MULT;
            }
            case 1: {
                return DIV;
            }
            case 2: {
                return MOD;
            }
        }
        return null;
    }

    private ProductOperations(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

