/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.tcfmoop.terminationcriteria;

import de.uka.ipd.sdq.tcfmoop.config.ElapsedTimeConfig;
import de.uka.ipd.sdq.tcfmoop.config.IConfiguration;
import de.uka.ipd.sdq.tcfmoop.outputtree.Node;
import de.uka.ipd.sdq.tcfmoop.terminationcriteria.AbstractTerminationCriterion;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import org.opt4j.core.optimizer.Archive;
import org.opt4j.core.optimizer.Population;

public class ElapsedTimeCriterion
extends AbstractTerminationCriterion {
    private long executionInterval;
    private long elapsedTime;
    private ElapsedTimeConfig.TimeType timeType;
    private long startTime;
    private ThreadMXBean threadMXBean;
    private boolean isCPUTimeMeasuringSupported;
    private Node timeTypeNode;
    private Node executionTimeNode;
    private Node remainingTimeNode;

    public ElapsedTimeCriterion(IConfiguration conf, Population population, Archive archive) {
        super(conf, population, archive);
        if (conf instanceof ElapsedTimeConfig && conf.validateConfiguration()) {
            this.executionInterval = ((ElapsedTimeConfig)conf).getExecutionInterval();
            this.timeType = ((ElapsedTimeConfig)conf).getTimeType();
            this.startTime = System.currentTimeMillis();
            if (this.timeType.equals((Object)ElapsedTimeConfig.TimeType.CPU_TIME)) {
                this.threadMXBean = ManagementFactory.getThreadMXBean();
                if (this.threadMXBean.isThreadCpuTimeSupported()) {
                    if (!this.threadMXBean.isThreadCpuTimeEnabled()) {
                        this.threadMXBean.setThreadCpuTimeEnabled(true);
                    }
                    this.isCPUTimeMeasuringSupported = true;
                } else {
                    this.isCPUTimeMeasuringSupported = false;
                }
            }
        } else {
            throw new RuntimeException("ElapsedTimeCriterion.initialize: wrong or invalid configuration object");
        }
        this.initializeOutputTree();
    }

    private void initializeOutputTree() {
        this.outputInformation.updateValue("Elapsed Time");
        this.outputInformation.getChildren().clear();
        this.timeTypeNode = this.timeType.equals((Object)ElapsedTimeConfig.TimeType.CPU_TIME) ? (!this.isCPUTimeMeasuringSupported ? this.outputInformation.addChild("Time Type: Cannot Meassure CPU Time. Measuring USER Time instead.", Node.NodeType.PARAMETER) : this.outputInformation.addChild("Time Type: CPU Time", Node.NodeType.PARAMETER)) : this.outputInformation.addChild("Time Type: USER Time", Node.NodeType.PARAMETER);
        this.executionTimeNode = this.outputInformation.addChild("Minimum Execution Time: " + this.executionInterval + " ms", Node.NodeType.PARAMETER);
        this.remainingTimeNode = this.outputInformation.addChild("Elapsed Time: " + this.elapsedTime + " ms", Node.NodeType.PARAMETER);
        this.outputInformation.getChildren().add(this.suggestedStop);
    }

    @Override
    public void evaluateImpl(int iteration, long currentTime) {
        if (this.timeType.equals((Object)ElapsedTimeConfig.TimeType.CPU_TIME)) {
            this.elapsedTime = this.isCPUTimeMeasuringSupported ? this.threadMXBean.getThreadCpuTime(Thread.currentThread().getId()) / 1000000L : currentTime - this.startTime;
        } else if (this.timeType.equals((Object)ElapsedTimeConfig.TimeType.USER_TIME)) {
            this.elapsedTime = currentTime - this.startTime;
        }
        this.evaluationResult = this.elapsedTime > this.executionInterval;
    }

    @Override
    public void updateOutputInformation() {
        this.executionTimeNode.updateValue("Minimum Execution Time: " + this.executionInterval + " ms");
        this.remainingTimeNode.updateValue("Elapsed Time: " + this.elapsedTime + " ms");
    }
}

