/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.tcfmoop.terminationcriteria;

import de.uka.ipd.sdq.tcfmoop.config.IConfiguration;
import de.uka.ipd.sdq.tcfmoop.config.MinimalQualityCriteriaValueConfig;
import de.uka.ipd.sdq.tcfmoop.outputtree.Node;
import de.uka.ipd.sdq.tcfmoop.terminationcriteria.AbstractTerminationCriterion;
import java.util.HashMap;
import java.util.Map;
import org.opt4j.core.Individual;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.Value;
import org.opt4j.core.optimizer.Archive;
import org.opt4j.core.optimizer.Population;

public class MinimalQualityCriteriaValueCriterion
extends AbstractTerminationCriterion {
    private Map<Objective, Value<?>> configuredObjectives = new HashMap();
    private int numberOfCandidatesToConform;
    private int currentlyConformingCandidates;
    private Node conformingCandidatesNode;

    public MinimalQualityCriteriaValueCriterion(IConfiguration conf, Population population, Archive archive) {
        super(conf, population, archive);
        if (!(conf instanceof MinimalQualityCriteriaValueConfig) || !conf.validateConfiguration()) {
            throw new RuntimeException("MinimalQualityCriteriaValueCriterion.initialize: wrong or invalid configuration object");
        }
        this.numberOfCandidatesToConform = ((MinimalQualityCriteriaValueConfig)conf).getNumberOfCandidatesToConform();
        this.configuredObjectives = ((MinimalQualityCriteriaValueConfig)conf).getObjectiveMinimalValues();
        this.initializeOutputTree();
    }

    private void initializeOutputTree() {
        this.outputInformation.updateValue("Minimal Quality Criteria Value");
        this.outputInformation.getChildren().clear();
        this.conformingCandidatesNode = this.outputInformation.addChild("Conforming Candidates: " + this.currentlyConformingCandidates + "/" + this.numberOfCandidatesToConform, Node.NodeType.PARAMETER);
        this.outputInformation.getChildren().add(this.suggestedStop);
    }

    @Override
    public void evaluateImpl(int iteration, long currentTime) {
        this.currentlyConformingCandidates = 0;
        for (Individual indi : this.archive) {
            if (!this.doesConformToMinimalValues(indi)) continue;
            ++this.currentlyConformingCandidates;
        }
        this.evaluationResult = this.currentlyConformingCandidates >= this.numberOfCandidatesToConform;
    }

    private boolean doesConformToMinimalValues(Individual indi) {
        Objectives currentCandidatesObjectives = indi.getObjectives();
        if (!currentCandidatesObjectives.getKeys().containsAll(this.configuredObjectives.keySet())) {
            throw new RuntimeException("MinimalQualityCriteriaValueCriterion.doesConformToMinimalValues: Individual does not contain all configured Objectives");
        }
        for (Map.Entry<Objective, Value<?>> keyValuePair : this.configuredObjectives.entrySet()) {
            if (!(keyValuePair.getKey().getSign() == Objective.Sign.MAX ? !(currentCandidatesObjectives.get(keyValuePair.getKey()).getDouble() >= keyValuePair.getValue().getDouble()) : keyValuePair.getKey().getSign() == Objective.Sign.MIN && !(currentCandidatesObjectives.get(keyValuePair.getKey()).getDouble() <= keyValuePair.getValue().getDouble()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void updateOutputInformation() {
        this.conformingCandidatesNode.updateValue("Conforming Candidates: " + this.currentlyConformingCandidates + "/" + this.numberOfCandidatesToConform);
    }
}

