/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.tcfmoop.tests;

import de.uka.ipd.sdq.tcfmoop.config.InsignificantSetQualityImprovementConfig;
import de.uka.ipd.sdq.tcfmoop.terminationcriteria.InsignificantSetQualityImprovementCriterion;
import java.util.HashSet;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opt4j.common.archive.DefaultArchive;
import org.opt4j.core.Individual;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.domination.DominationStrategy;
import org.opt4j.core.domination.ParetoDomination;
import org.opt4j.core.optimizer.Archive;
import org.opt4j.core.optimizer.Population;

public class InsignificantSetQualityImprovementCriterionTest {
    InsignificantSetQualityImprovementConfig isqiconf;
    InsignificantSetQualityImprovementCriterion isqiccrit;
    Archive archive = new DefaultArchive();
    Objectives o1 = new Objectives((DominationStrategy)new ParetoDomination());
    Objectives o2 = new Objectives((DominationStrategy)new ParetoDomination());
    Objectives o3 = new Objectives((DominationStrategy)new ParetoDomination());
    Objectives o4 = new Objectives((DominationStrategy)new ParetoDomination());
    Objectives o5 = new Objectives((DominationStrategy)new ParetoDomination());
    Objectives o6 = new Objectives((DominationStrategy)new ParetoDomination());
    Objectives o7 = new Objectives((DominationStrategy)new ParetoDomination());
    MyIndividual i1 = new MyIndividual();
    MyIndividual i2 = new MyIndividual();
    MyIndividual i3 = new MyIndividual();
    MyIndividual i4 = new MyIndividual();
    MyIndividual i5 = new MyIndividual();
    MyIndividual i6 = new MyIndividual();
    MyIndividual i7 = new MyIndividual();
    Objective X = new Objective("X", Objective.Sign.MIN);
    Objective Y = new Objective("Y", Objective.Sign.MIN);

    @Before
    public void setUp() throws Exception {
        this.isqiconf = new InsignificantSetQualityImprovementConfig();
        this.o1.add(this.X, 2);
        this.o1.add(this.Y, 6);
        this.o2.add(this.X, 4);
        this.o2.add(this.Y, 3);
        this.o3.add(this.X, 6);
        this.o3.add(this.Y, 1);
        this.o4.add(this.X, 8);
        this.o4.add(this.Y, 0.5);
        this.i1.setObjectives(this.o1);
        this.i2.setObjectives(this.o2);
        this.i3.setObjectives(this.o3);
        this.i4.setObjectives(this.o4);
        this.archive.add((Individual)this.i1);
        this.archive.add((Individual)this.i2);
        this.archive.add((Individual)this.i3);
        this.archive.add((Individual)this.i4);
        this.o5.add(this.X, 30);
        this.o5.add(this.Y, 0.5);
        this.i5.setObjectives(this.o5);
        this.o6.add(this.X, 5);
        this.o6.add(this.Y, 0.5);
        this.i6.setObjectives(this.o6);
        this.o7.add(this.X, 1);
        this.o7.add(this.Y, 0.5);
        this.i7.setObjectives(this.o7);
        this.isqiconf.setComparisionGenerations(2);
        LinkedList<InsignificantSetQualityImprovementConfig.ValueDifference> vDiffs = new LinkedList<InsignificantSetQualityImprovementConfig.ValueDifference>();
        InsignificantSetQualityImprovementConfig insignificantSetQualityImprovementConfig = this.isqiconf;
        insignificantSetQualityImprovementConfig.getClass();
        vDiffs.add(insignificantSetQualityImprovementConfig.new InsignificantSetQualityImprovementConfig.ValueDifference(this.X, 0.25, 0.1));
        InsignificantSetQualityImprovementConfig insignificantSetQualityImprovementConfig2 = this.isqiconf;
        insignificantSetQualityImprovementConfig2.getClass();
        vDiffs.add(insignificantSetQualityImprovementConfig2.new InsignificantSetQualityImprovementConfig.ValueDifference(this.Y, 0.25, 0.1));
        this.isqiconf.setValueDifferences(vDiffs);
        if (!this.isqiconf.validateConfiguration()) {
            throw new Exception();
        }
    }

    @Test
    public void testInsignificantChange() {
        Population population = new Population();
        population.add((Individual)this.i1);
        this.isqiccrit = new InsignificantSetQualityImprovementCriterion(this.isqiconf, population, this.archive);
        this.isqiccrit.evaluate(0, 0L);
        Assert.assertFalse((boolean)this.isqiccrit.getEvaluationResult());
        this.isqiccrit.evaluate(0, 0L);
        Assert.assertFalse((boolean)this.isqiccrit.getEvaluationResult());
        this.archive.add((Individual)this.i6);
        this.isqiccrit.evaluate(0, 0L);
        Assert.assertTrue((boolean)this.isqiccrit.getEvaluationResult());
        this.archive.remove((Object)this.i6);
    }

    @Test
    public void testInsignificantChangeWithSignificantMinimum() {
        Population population = new Population();
        population.add((Individual)this.i1);
        this.isqiccrit = new InsignificantSetQualityImprovementCriterion(this.isqiconf, population, this.archive);
        this.isqiccrit.evaluate(0, 0L);
        Assert.assertFalse((boolean)this.isqiccrit.getEvaluationResult());
        this.isqiccrit.evaluate(0, 0L);
        Assert.assertFalse((boolean)this.isqiccrit.getEvaluationResult());
        this.archive.add((Individual)this.i7);
        this.isqiccrit.evaluate(0, 0L);
        Assert.assertFalse((boolean)this.isqiccrit.getEvaluationResult());
        this.archive.remove((Object)this.i7);
    }

    @Test
    public void testSignificantChange() {
        Population population = new Population();
        population.add((Individual)this.i1);
        this.isqiccrit = new InsignificantSetQualityImprovementCriterion(this.isqiconf, population, this.archive);
        this.isqiccrit.evaluate(0, 0L);
        Assert.assertFalse((boolean)this.isqiccrit.getEvaluationResult());
        this.isqiccrit.evaluate(0, 0L);
        Assert.assertFalse((boolean)this.isqiccrit.getEvaluationResult());
        this.archive.add((Individual)this.i5);
        this.isqiccrit.evaluate(0, 0L);
        Assert.assertFalse((boolean)this.isqiccrit.getEvaluationResult());
    }

    public class MyIndividual
    extends Individual {
        public MyIndividual() {
            this.setIndividualStatusListeners(new HashSet());
        }
    }
}

