/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.logging.console;

import de.uka.ipd.sdq.workflow.logging.console.IAppenderListener;
import de.uka.ipd.sdq.workflow.logging.console.StreamsProxyAppender;
import java.util.ArrayList;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;

public class AppenderBasedStreamMonitor
implements IStreamMonitor,
IAppenderListener {
    private ArrayList<IStreamListener> myListener = new ArrayList();
    private StringBuffer myText = new StringBuffer();
    private Priority internalLogLevel;
    private ComparisonOperator comparisionOperator;

    public AppenderBasedStreamMonitor(Level logLevel, ComparisonOperator op) {
        this.internalLogLevel = logLevel;
        this.comparisionOperator = op;
    }

    public void addListener(IStreamListener listener) {
        this.myListener.add(listener);
    }

    public void removeListener(IStreamListener listener) {
        this.myListener.remove(listener);
    }

    public String getContents() {
        return this.myText.toString();
    }

    public void addAppender(StreamsProxyAppender appender) {
        appender.addAppenderListener(this);
    }

    public void removeAppender(StreamsProxyAppender appender) {
        appender.removeAppenderListener(this);
    }

    protected void notifyListeners(String text) {
        for (IStreamListener listener : this.myListener) {
            listener.streamAppended(text, (IStreamMonitor)this);
        }
        this.myText.append(text);
    }

    @Override
    public void textAddedEvent(String text, Level level) {
        if (this.comparisionOperator == ComparisonOperator.LESS_THAN) {
            if (!level.isGreaterOrEqual(this.internalLogLevel)) {
                this.notifyListeners(text);
            }
        } else if (level.isGreaterOrEqual(this.internalLogLevel)) {
            this.notifyListeners(text);
        }
    }

    public static enum ComparisonOperator {
        LESS_THAN,
        GREATER_OR_EQUAL_THAN;

    }
}

