/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.mdsd.emf.qvto;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvto.QVTOResult;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvto.QVTOTransformationJobConfiguration;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvto.internal.QVTOExecutor;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;

public class QVTOTransformationJob
implements IBlackboardInteractingJob<MDSDBlackboard> {
    private final Logger logger = Logger.getLogger(QVTOTransformationJob.class);
    private final QVTOTransformationJobConfiguration configuration;
    private MDSDBlackboard blackboard;

    public QVTOTransformationJob(QVTOTransformationJobConfiguration conf) {
        this.configuration = conf;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        if (this.logger.isEnabledFor((Priority)Level.INFO)) {
            this.logger.info((Object)"Executing QVTO Transformation...");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Script: " + this.configuration.getScriptFileURI()));
        }
        List<EObject>[] parameter = this.getModelContents();
        QVTOResult result = QVTOExecutor.execute(this.configuration.getScriptFileURI(), this.configuration.getOptions(), parameter);
        if (!result.isSuccess()) {
            if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
                this.logger.error((Object)"Transformation job failed");
                this.logger.error((Object)result.getDiagnosticResult().getMessage());
            }
            result.logStackTrace(this.logger, Level.ERROR);
            throw new JobFailedException("Transformation execution failed");
        }
        this.storeResultOnBlackboard(parameter);
        if (this.logger.isEnabledFor((Priority)Level.INFO)) {
            this.logger.info((Object)"Transformation executed successfully");
        }
    }

    private void storeResultOnBlackboard(List<EObject>[] parameter) {
        int i = 0;
        while (i < parameter.length) {
            this.blackboard.setContents(this.configuration.getInoutModels()[i], parameter[i]);
            ++i;
        }
    }

    private List<EObject>[] getModelContents() {
        List[] modelContents = new List[this.configuration.getInoutModels().length];
        int i = 0;
        while (i < this.configuration.getInoutModels().length) {
            modelContents[i] = this.blackboard.modelExists(this.configuration.getInoutModels()[i]) ? this.blackboard.getContents(this.configuration.getInoutModels()[i]) : Collections.EMPTY_LIST;
            ++i;
        }
        return modelContents;
    }

    public String getName() {
        return "Perform QVT Operational Transformation";
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

