/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.mdsd.emf.qvto.internal;

import de.uka.ipd.sdq.workflow.mdsd.Activator;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvto.QVTOResult;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvto.internal.QVTOLogger;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvto.internal.TransformationExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.util.Log;

public class QVTOExecutor {
    public static QVTOResult execute(URI transformationURI, List<EObject>[] inoutParameter) {
        return QVTOExecutor.execute(transformationURI, new HashMap<String, Object>(), inoutParameter);
    }

    public static QVTOResult execute(URI transformationURI, Map<String, Object> parameters, List<EObject>[] inoutParameter) {
        TransformationExecutor executor = new TransformationExecutor(transformationURI);
        ModelExtent[] transformationParameter = new ModelExtent[inoutParameter.length];
        int i = 0;
        while (i < inoutParameter.length) {
            transformationParameter[i] = new BasicModelExtent();
            if (inoutParameter[i] != null) {
                ArrayList<EObject> contents = new ArrayList<EObject>();
                contents.addAll(inoutParameter[i]);
                transformationParameter[i].setContents(contents);
            }
            ++i;
        }
        ExecutionContextImpl context = new ExecutionContextImpl();
        for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
            context.setConfigProperty(parameter.getKey(), parameter.getValue());
        }
        context.setLog((Log)new QVTOLogger());
        ExecutionDiagnostic result = executor.execute((ExecutionContext)context, transformationParameter);
        QVTOResult qvtResult = null;
        if (result.getSeverity() != 0) {
            qvtResult = new QVTOResult(result);
            IStatus status = BasicDiagnostic.toIStatus((Diagnostic)result);
            Activator.getDefault().getLog().log(status);
        } else {
            qvtResult = new QVTOResult(result, executor.getLastTrace());
            int i2 = 0;
            while (i2 < inoutParameter.length) {
                assert (transformationParameter[i2].getContents().size() == 1);
                inoutParameter[i2] = transformationParameter[i2].getContents();
                ++i2;
            }
        }
        return qvtResult;
    }
}

