/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.mdsd.emf.qvtr;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;

public class QVTRScript {
    private String qvtScriptFile = "";
    private String transformationName = "";
    private String transformationDirection = "";
    private Collection<Object> metaModels;
    private final Logger logger = Logger.getLogger(QVTRScript.class);

    public String toString() {
        return this.qvtScriptFile;
    }

    public String getTransformationName() {
        return this.transformationName;
    }

    public String getTransformationDirection() {
        return this.transformationDirection;
    }

    public void setTransformationName(String transformationName) {
        this.transformationName = transformationName;
    }

    public void setTransformationDirection(String transformationDirection) {
        this.transformationDirection = transformationDirection;
    }

    public Reader toReader() {
        return new StringReader(this.qvtScriptFile);
    }

    public void setQVTFile(String fileName) {
        URI qvturl = null;
        try {
            qvturl = URI.createURI((String)fileName);
        }
        catch (IllegalArgumentException e) {
            this.logger.error((Object)"Wrong URI format.", (Throwable)e);
        }
        try {
            String line;
            InputStream stream = null;
            if (qvturl.scheme().startsWith("platform")) {
                stream = URIConverter.INSTANCE.createInputStream(qvturl);
            } else {
                qvturl = CommonPlugin.resolve((URI)qvturl);
                stream = new FileInputStream(qvturl.toFileString());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(stream));
            StringBuffer contentOfFile = new StringBuffer();
            while ((line = br.readLine()) != null) {
                contentOfFile.append(line);
                contentOfFile.append("\n");
            }
            this.qvtScriptFile = contentOfFile.toString();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (IOException ioException) {
            this.logger.info((Object)"Error reading the QVT file.", (Throwable)ioException);
        }
    }

    public void setMetaModels(Collection<Object> metaModels) {
        this.metaModels = metaModels;
    }

    public Collection<Object> getMetaModels() {
        return this.metaModels;
    }
}

