/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.mdsd.emf.qvtr.jobs;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ModelLocation;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvtr.AbstractQVTREngine;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvtr.jobs.QVTRTransformationJobConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class QVTRTransformationJob
implements IBlackboardInteractingJob<MDSDBlackboard> {
    private final Logger logger = Logger.getLogger(QVTRTransformationJob.class);
    protected QVTRTransformationJobConfiguration configuration;
    protected MDSDBlackboard blackboard;

    public QVTRTransformationJob(QVTRTransformationJobConfiguration configuration) {
        this.configuration = configuration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        ResourceSetPartition oldTracesPartition;
        this.logger.info((Object)"Executing QVTR Transformation...");
        this.logger.debug((Object)("Script: " + this.configuration.getQVTRScript()));
        AbstractQVTREngine qvtrEngine = AbstractQVTREngine.getInstance(this.configuration.getQvtEngineID());
        if (qvtrEngine == null) {
            throw new JobFailedException("No QVT-R Engine available.");
        }
        qvtrEngine.setDebug(this.configuration.isDebug());
        if (this.configuration.getProperties() != null) {
            Map<String, String> properties = this.configuration.getProperties();
            for (Map.Entry<String, String> property : properties.entrySet()) {
                qvtrEngine.setProperty(property.getKey(), property.getValue());
            }
        }
        if (this.configuration.getTracesPartitionName() != null) {
            ResourceSetPartition tracesPartition = (ResourceSetPartition)this.blackboard.getPartition(this.configuration.getTracesPartitionName());
            if (tracesPartition == null) {
                tracesPartition = new ResourceSetPartition();
                this.blackboard.addPartition(this.configuration.getTracesPartitionName(), tracesPartition);
            }
            qvtrEngine.setTracesResourceSet(tracesPartition.getResourceSet());
        }
        if (this.configuration.getOldTracesPartitionName() != null && (oldTracesPartition = (ResourceSetPartition)this.blackboard.getPartition(this.configuration.getOldTracesPartitionName())) != null) {
            qvtrEngine.setOldTracesResourceSet(oldTracesPartition.getResourceSet());
        }
        qvtrEngine.setWorkingDirectory(this.configuration.getTraceFileURI());
        for (ModelLocation[] modelLocation : this.configuration.getModelLocationSets()) {
            qvtrEngine.addModels(this.getResources(modelLocation));
        }
        qvtrEngine.setQVTRScript(this.configuration.getQVTRScript());
        qvtrEngine.setExtendedDebugingLog(this.configuration.getExtendedDebuggingLog());
        try {
            qvtrEngine.transform();
        }
        catch (Throwable e) {
            throw new JobFailedException("Error in mediniQVT Transformation", e);
        }
        this.logger.info((Object)"Transformation executed successfully");
    }

    protected Collection<Resource> getResources(ModelLocation[] modelLocations) {
        ArrayList<Resource> resources = new ArrayList<Resource>(modelLocations.length);
        ModelLocation[] modelLocationArray = modelLocations;
        int n = modelLocations.length;
        int n2 = 0;
        while (n2 < n) {
            ModelLocation modelLocation = modelLocationArray[n2];
            resources.add(this.getResource(modelLocation));
            ++n2;
        }
        return resources;
    }

    protected Resource getResource(ModelLocation modelLocation) {
        ResourceSetPartition partition = (ResourceSetPartition)this.blackboard.getPartition(modelLocation.getPartitionID());
        ResourceSet rSet = partition.getResourceSet();
        Resource r = rSet.getResource(modelLocation.getModelID(), false);
        if (r == null) {
            new IllegalArgumentException("Model with URI " + modelLocation.getModelID() + " must be loaded first");
        }
        return r;
    }

    public String getName() {
        return "Run a relational mediniQVT transformation";
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

