/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.mdsd.xtext.generator;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ModelLocation;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

public class PrepareXTextPartitionJob
implements IJob,
IBlackboardInteractingJob<MDSDBlackboard> {
    private final Logger logger = Logger.getLogger(PrepareXTextPartitionJob.class);
    private MDSDBlackboard blackboard;
    private final ModelLocation modelLocation;

    public PrepareXTextPartitionJob(ModelLocation modelLocation) {
        this.modelLocation = modelLocation;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        this.logger.debug((Object)"Creating XText model partition");
        ResourceSetPartition modelPartition = new ResourceSetPartition();
        this.blackboard.addPartition(this.modelLocation.getPartitionID(), modelPartition);
        modelPartition.loadModel(this.modelLocation.getModelID());
    }

    public String getName() {
        return "Prepare XText Blackboard Partions";
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
        this.blackboard.removePartition(this.modelLocation.getPartitionID());
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

