/*
 * Decompiled with CFR 0.152.
 */
package de.upb.swt.core.ui.properties.sections;

import de.upb.swt.core.ui.CoreImages;
import de.upb.swt.core.ui.properties.sections.AbstractFeaturePropertySection;
import de.upb.swt.core.ui.properties.util.State;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public abstract class AbstractComboSection<T>
extends AbstractFeaturePropertySection {
    private final Map<Integer, T> map = new LinkedHashMap<Integer, T>();
    private Label label;
    private Composite composite;
    private Combo combo;
    private Button button;
    private Label icon;

    @Override
    public void refresh() {
        if (this.isReady()) {
            this.map.clear();
            int index = 0;
            List<T> items = this.getItems();
            String[] itemTexts = new String[items.size()];
            for (T object : items) {
                this.map.put(index, object);
                itemTexts[index] = this.getText(object);
                ++index;
            }
            this.combo.setItems(itemTexts);
            if (this.hasChanged()) {
                T value = this.getValue();
                if (this.getElement() != null) {
                    this.combo.select(this.getIndex(value));
                } else {
                    this.combo.select(-1);
                }
                this.validate();
            }
        }
    }

    @Override
    protected void createWidgets(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        this.label = factory.createLabel(parent, String.valueOf(this.getLabelText()) + ':', 131072);
        this.composite = factory.createFlatFormComposite(parent);
        this.combo = new Combo(this.composite, 2056);
        factory.adapt((Composite)this.combo);
        if (this.shouldShowButton()) {
            this.button = factory.createButton(this.composite, "Find", 8);
            this.button.setImage(CoreImages.get((String)"icons/find.png"));
        }
        this.icon = factory.createLabel(parent, "");
    }

    private void validate() {
        this.decorateImage(this.icon, this.validate(this.getValue()));
    }

    protected T getValue() {
        return (T)super.getValue();
    }

    @Override
    protected abstract EStructuralFeature getFeature();

    protected abstract List<T> getItems();

    protected abstract String getLabelText();

    protected String getText(T element) {
        return String.valueOf(element);
    }

    protected void handleButtonClicked() {
    }

    @Override
    protected void hookWidgetListeners() {
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractComboSection.this.set(AbstractComboSection.this.map.get(AbstractComboSection.this.combo.getSelectionIndex()));
                AbstractComboSection.this.validate();
            }
        });
        if (this.shouldShowButton()) {
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractComboSection.this.handleButtonClicked();
                }
            });
        }
    }

    @Override
    protected void layoutWidgets() {
        GridLayoutFactory.fillDefaults().numColumns(this.shouldShowButton() ? 2 : 1).applyTo(this.composite);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.combo);
        if (this.shouldShowButton()) {
            GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.button);
        }
        FormData data = new FormData();
        data.left = new FormAttachment(0, 120);
        data.right = new FormAttachment(100, -34);
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        this.composite.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.composite, 12, 131072);
        data.right = new FormAttachment(100, -6);
        data.top = new FormAttachment((Control)this.composite, 0, 128);
        data.bottom = new FormAttachment((Control)this.composite, 0, 1024);
        this.icon.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment((Control)this.composite, -6);
        data.top = new FormAttachment((Control)this.composite, 2, 128);
        data.bottom = new FormAttachment((Control)this.composite, 0, 1024);
        this.label.setLayoutData((Object)data);
    }

    protected boolean shouldShowButton() {
        return false;
    }

    protected State validate(T value) {
        return State.NONE;
    }

    private int getIndex(Object element) {
        boolean isNull = element == null;
        for (Integer key : this.map.keySet()) {
            T value = this.map.get(key);
            if (!(isNull ? value == null : element.equals(value))) continue;
            return key;
        }
        return -1;
    }

    private boolean hasChanged() {
        T oldValue = this.map.get(this.combo.getSelectionIndex());
        T newValue = this.getValue();
        if (oldValue != null && oldValue.equals(newValue)) {
            return false;
        }
        if (newValue != null && newValue.equals(oldValue)) {
            return false;
        }
        return newValue != null || oldValue != null;
    }

    private boolean isReady() {
        return this.combo != null && !this.combo.isDisposed();
    }
}

