/**
 * 
 * Copyright (c) 2009 Hatha Systems.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nikolai Mansourov (Hatha Systems) - initial API and implementation
 *     Gabriel Barbier (Mia-Software) - minor evolutions for version 1.1
 */
package org.eclipse.gmt.modisco.omg.kdm.source.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.gmt.modisco.omg.kdm.source.util.SourceAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class SourceItemProviderAdapterFactory extends SourceAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SourceItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.omg.kdm.source.InventoryModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InventoryModelItemProvider inventoryModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.omg.kdm.source.InventoryModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInventoryModelAdapter() {
		if (inventoryModelItemProvider == null) {
			inventoryModelItemProvider = new InventoryModelItemProvider(this);
		}

		return inventoryModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.omg.kdm.source.InventoryItem} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InventoryItemItemProvider inventoryItemItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.omg.kdm.source.InventoryItem}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInventoryItemAdapter() {
		if (inventoryItemItemProvider == null) {
			inventoryItemItemProvider = new InventoryItemItemProvider(this);
		}

		return inventoryItemItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.omg.kdm.source.SourceFile} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SourceFileItemProvider sourceFileItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.omg.kdm.source.SourceFile}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSourceFileAdapter() {
		if (sourceFileItemProvider == null) {
			sourceFileItemProvider = new SourceFileItemProvider(this);
		}

		return sourceFileItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.omg.kdm.source.Image} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ImageItemProvider imageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.omg.kdm.source.Image}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createImageAdapter() {
		if (imageItemProvider == null) {
			imageItemProvider = new ImageItemProvider(this);
		}

		return imageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.omg.kdm.source.Configuration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConfigurationItemProvider configurationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.omg.kdm.source.Configuration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConfigurationAdapter() {
		if (configurationItemProvider == null) {
			configurationItemProvider = new ConfigurationItemProvider(this);
		}

		return configurationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.omg.kdm.source.ResourceDescription} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ResourceDescriptionItemProvider resourceDescriptionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.omg.kdm.source.ResourceDescription}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createResourceDescriptionAdapter() {
		if (resourceDescriptionItemProvider == null) {
			resourceDescriptionItemProvider = new ResourceDescriptionItemProvider(this);
		}

		return resourceDescriptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.omg.kdm.source.BinaryFile} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BinaryFileItemProvider binaryFileItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.omg.kdm.source.BinaryFile}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBinaryFileAdapter() {
		if (binaryFileItemProvider == null) {
			binaryFileItemProvider = new BinaryFileItemProvider(this);
		}

		return binaryFileItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.omg.kdm.source.ExecutableFile} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExecutableFileItemProvider executableFileItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.omg.kdm.source.ExecutableFile}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExecutableFileAdapter() {
		if (executableFileItemProvider == null) {
			executableFileItemProvider = new ExecutableFileItemProvider(this);
		}

		return executableFileItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.omg.kdm.source.InventoryContainer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InventoryContainerItemProvider inventoryContainerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.omg.kdm.source.InventoryContainer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInventoryContainerAdapter() {
		if (inventoryContainerItemProvider == null) {
			inventoryContainerItemProvider = new InventoryContainerItemProvider(this);
		}

		return inventoryContainerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.omg.kdm.source.Directory} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DirectoryItemProvider directoryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.omg.kdm.source.Directory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDirectoryAdapter() {
		if (directoryItemProvider == null) {
			directoryItemProvider = new DirectoryItemProvider(this);
		}

		return directoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.omg.kdm.source.Project} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProjectItemProvider projectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.omg.kdm.source.Project}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProjectAdapter() {
		if (projectItemProvider == null) {
			projectItemProvider = new ProjectItemProvider(this);
		}

		return projectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.omg.kdm.source.DependsOn} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DependsOnItemProvider dependsOnItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.omg.kdm.source.DependsOn}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDependsOnAdapter() {
		if (dependsOnItemProvider == null) {
			dependsOnItemProvider = new DependsOnItemProvider(this);
		}

		return dependsOnItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.omg.kdm.source.SourceRef} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SourceRefItemProvider sourceRefItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.omg.kdm.source.SourceRef}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSourceRefAdapter() {
		if (sourceRefItemProvider == null) {
			sourceRefItemProvider = new SourceRefItemProvider(this);
		}

		return sourceRefItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.omg.kdm.source.SourceRegion} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SourceRegionItemProvider sourceRegionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.omg.kdm.source.SourceRegion}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSourceRegionAdapter() {
		if (sourceRegionItemProvider == null) {
			sourceRegionItemProvider = new SourceRegionItemProvider(this);
		}

		return sourceRegionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.omg.kdm.source.InventoryElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InventoryElementItemProvider inventoryElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.omg.kdm.source.InventoryElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInventoryElementAdapter() {
		if (inventoryElementItemProvider == null) {
			inventoryElementItemProvider = new InventoryElementItemProvider(this);
		}

		return inventoryElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.omg.kdm.source.InventoryRelationship} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InventoryRelationshipItemProvider inventoryRelationshipItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.omg.kdm.source.InventoryRelationship}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInventoryRelationshipAdapter() {
		if (inventoryRelationshipItemProvider == null) {
			inventoryRelationshipItemProvider = new InventoryRelationshipItemProvider(this);
		}

		return inventoryRelationshipItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (inventoryModelItemProvider != null) inventoryModelItemProvider.dispose();
		if (inventoryItemItemProvider != null) inventoryItemItemProvider.dispose();
		if (sourceFileItemProvider != null) sourceFileItemProvider.dispose();
		if (imageItemProvider != null) imageItemProvider.dispose();
		if (configurationItemProvider != null) configurationItemProvider.dispose();
		if (resourceDescriptionItemProvider != null) resourceDescriptionItemProvider.dispose();
		if (binaryFileItemProvider != null) binaryFileItemProvider.dispose();
		if (executableFileItemProvider != null) executableFileItemProvider.dispose();
		if (inventoryContainerItemProvider != null) inventoryContainerItemProvider.dispose();
		if (directoryItemProvider != null) directoryItemProvider.dispose();
		if (projectItemProvider != null) projectItemProvider.dispose();
		if (dependsOnItemProvider != null) dependsOnItemProvider.dispose();
		if (sourceRefItemProvider != null) sourceRefItemProvider.dispose();
		if (sourceRegionItemProvider != null) sourceRegionItemProvider.dispose();
		if (inventoryElementItemProvider != null) inventoryElementItemProvider.dispose();
		if (inventoryRelationshipItemProvider != null) inventoryRelationshipItemProvider.dispose();
	}

}
