/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.application.decorator.gmf.decoration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.AbstractDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.Decoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Image;
import org.modelversioning.emfprofile.application.decorator.gmf.EMFProfileApplicationDecoratorImpl;
import org.modelversioning.emfprofile.application.decorator.gmf.decoration.provider.GMFProfileDecoratorProvider;

public class EMFProfileDecorator
extends AbstractDecorator {
    private List<Image> images = new ArrayList<Image>();
    private List<String> toolTipTexts = new ArrayList<String>();
    private Set<IDecoration> decorations = new HashSet<IDecoration>();

    public EMFProfileDecorator(IDecoratorTarget decoratorTarget) {
        super(decoratorTarget);
    }

    public Set<IDecoration> getDecorations() {
        return this.decorations;
    }

    public void addDecoration(IDecoration decoration) {
        this.decorations.add(decoration);
    }

    protected void removeDecorations() {
        for (IDecoration decoration : this.decorations) {
            this.getDecoratorTarget().removeDecoration(decoration);
        }
        this.decorations.clear();
    }

    public void refresh(List<Image> images, List<String> toolTipTexts) {
        this.images = images;
        this.toolTipTexts = toolTipTexts;
        this.refresh();
    }

    public void refresh() {
        this.removeDecorations();
        View view = (View)this.getDecoratorTarget().getAdapter(View.class);
        if (view == null || view.eResource() == null) {
            return;
        }
        EditPart editPart = (EditPart)this.getDecoratorTarget().getAdapter(EditPart.class);
        if (editPart == null || editPart.getViewer() == null) {
            return;
        }
        if (this.images.size() > 0) {
            Label toolTip = new Label();
            FlowLayout fl = new FlowLayout(false);
            fl.setMinorSpacing(0);
            toolTip.setLayoutManager((LayoutManager)fl);
            int i = 0;
            while (i < this.images.size()) {
                toolTip.add((IFigure)new Label(this.toolTipTexts.get(i), this.images.get(i)));
                ++i;
            }
            if (editPart instanceof GraphicalEditPart) {
                Decoration decoration = null;
                if (view instanceof Edge) {
                    decoration = (Decoration)this.getDecoratorTarget().addConnectionDecoration(this.images.get(0), 50, true);
                } else {
                    int margin = -1;
                    decoration = (Decoration)this.getDecoratorTarget().addShapeDecoration(this.images.get(0), IDecoratorTarget.Direction.NORTH_WEST, margin, true);
                }
                decoration.setEnabled(true);
                decoration.setVisible(true);
                decoration.setToolTip((IFigure)toolTip);
                this.addDecoration((IDecoration)decoration);
            }
        }
    }

    public void activate() {
        EObject eObject = GMFProfileDecoratorProvider.getDecoratorTargetElement((IDecoratorTarget)this.getDecoratorTarget());
        if (eObject != null) {
            EMFProfileApplicationDecoratorImpl.registerDecoratorForEObject(eObject, (IDecorator)this);
        }
    }

    public void deactivate() {
        EObject eObject = GMFProfileDecoratorProvider.getDecoratorTargetElement((IDecoratorTarget)this.getDecoratorTarget());
        if (eObject != null) {
            EMFProfileApplicationDecoratorImpl.unregisterDecoratorForEObject(eObject);
        }
        super.deactivate();
    }
}

