/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.diagram.providers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.AbstractDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.CreateDecoratorsOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.modelversioning.emfprofile.diagram.part.EMFProfileDiagramEditor;
import org.modelversioning.emfprofile.diagram.part.EMFProfileDiagramEditorPlugin;
import org.modelversioning.emfprofile.diagram.part.EMFProfileVisualIDRegistry;
import org.modelversioning.emfprofile.diagram.part.ValidationMarker;

public class EMFProfileValidationDecoratorProvider
extends AbstractProvider
implements IDecoratorProvider {
    private static final String KEY = "validationStatus";
    private static Map allDecorators = new HashMap();

    public void createDecorators(IDecoratorTarget decoratorTarget) {
        EditPart editPart = (EditPart)decoratorTarget.getAdapter(EditPart.class);
        if (editPart instanceof GraphicalEditPart || editPart instanceof AbstractConnectionEditPart) {
            View view;
            Object model = editPart.getModel();
            if (model instanceof View && !((view = (View)model) instanceof Edge) && !view.isSetElement()) {
                return;
            }
            EditDomain ed = editPart.getViewer().getEditDomain();
            if (!(ed instanceof DiagramEditDomain)) {
                return;
            }
            if (((DiagramEditDomain)ed).getEditorPart() instanceof EMFProfileDiagramEditor) {
                decoratorTarget.installDecorator((Object)KEY, (IDecorator)new StatusDecorator(decoratorTarget));
            }
        }
    }

    public boolean provides(IOperation operation) {
        if (!(operation instanceof CreateDecoratorsOperation)) {
            return false;
        }
        IDecoratorTarget decoratorTarget = ((CreateDecoratorsOperation)operation).getDecoratorTarget();
        View view = (View)decoratorTarget.getAdapter(View.class);
        return view != null && "EMFProfile".equals(EMFProfileVisualIDRegistry.getModelID(view));
    }

    public static void refreshDecorators(View view) {
        EMFProfileValidationDecoratorProvider.refreshDecorators(ViewUtil.getIdStr((View)view), view.getDiagram());
    }

    private static void refreshDecorators(String viewId, Diagram diagram) {
        List decorators;
        List list = decorators = viewId != null ? (List)allDecorators.get(viewId) : null;
        if (decorators == null || decorators.isEmpty() || diagram == null) {
            return;
        }
        final Diagram fdiagram = diagram;
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    TransactionUtil.getEditingDomain((EObject)fdiagram).runExclusive(new Runnable(){

                        @Override
                        public void run() {
                            for (IDecorator decorator : decorators) {
                                decorator.refresh();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    EMFProfileDiagramEditorPlugin.getInstance().logError("Decorator refresh failure", e);
                }
            }
        });
    }

    public static class StatusDecorator
    extends AbstractDecorator {
        private String viewId;

        public StatusDecorator(IDecoratorTarget decoratorTarget) {
            super(decoratorTarget);
            try {
                final View view = (View)this.getDecoratorTarget().getAdapter(View.class);
                TransactionUtil.getEditingDomain((EObject)view).runExclusive(new Runnable(){

                    @Override
                    public void run() {
                        StatusDecorator.this.viewId = view != null ? ViewUtil.getIdStr((View)view) : null;
                    }
                });
            }
            catch (Exception e) {
                EMFProfileDiagramEditorPlugin.getInstance().logError("ViewID access failure", e);
            }
        }

        public void refresh() {
            this.removeDecoration();
            View view = (View)this.getDecoratorTarget().getAdapter(View.class);
            if (view == null || view.eResource() == null) {
                return;
            }
            EditPart editPart = (EditPart)this.getDecoratorTarget().getAdapter(EditPart.class);
            if (editPart == null || editPart.getViewer() == null) {
                return;
            }
            int severity = 1;
            ValidationMarker foundMarker = null;
            ValidationMarker[] markers = ValidationMarker.getMarkers(editPart.getViewer(), this.viewId);
            if (markers == null || markers.length == 0) {
                return;
            }
            Label toolTip = null;
            int i = 0;
            while (i < markers.length) {
                ValidationMarker marker = markers[i];
                int nextSeverity = marker.getStatusSeverity();
                Image nextImage = this.getImage(nextSeverity);
                if (foundMarker == null) {
                    foundMarker = marker;
                    toolTip = new Label(marker.getMessage(), nextImage);
                } else {
                    if (toolTip.getChildren().isEmpty()) {
                        Label comositeLabel = new Label();
                        FlowLayout fl = new FlowLayout(false);
                        fl.setMinorSpacing(0);
                        comositeLabel.setLayoutManager((LayoutManager)fl);
                        comositeLabel.add((IFigure)toolTip);
                        toolTip = comositeLabel;
                    }
                    toolTip.add((IFigure)new Label(marker.getMessage(), nextImage));
                }
                severity = nextSeverity > severity ? nextSeverity : severity;
                ++i;
            }
            if (foundMarker == null) {
                return;
            }
            if (editPart instanceof org.eclipse.gef.GraphicalEditPart) {
                if (view instanceof Edge) {
                    this.setDecoration(this.getDecoratorTarget().addConnectionDecoration(this.getImage(severity), 50, true));
                } else {
                    int margin = -1;
                    if (editPart instanceof org.eclipse.gef.GraphicalEditPart) {
                        margin = MapModeUtil.getMapMode((IFigure)((org.eclipse.gef.GraphicalEditPart)editPart).getFigure()).DPtoLP(margin);
                    }
                    this.setDecoration(this.getDecoratorTarget().addShapeDecoration(this.getImage(severity), IDecoratorTarget.Direction.NORTH_EAST, margin, true));
                }
                this.getDecoration().setToolTip((IFigure)toolTip);
            }
        }

        private Image getImage(int severity) {
            String imageName = "IMG_OBJS_ERROR_TSK";
            switch (severity) {
                case 4: {
                    imageName = "IMG_OBJS_ERROR_TSK";
                    break;
                }
                case 2: {
                    imageName = "IMG_OBJS_WARN_TSK";
                    break;
                }
                default: {
                    imageName = "IMG_OBJS_INFO_TSK";
                }
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageName);
        }

        public void activate() {
            if (this.viewId == null) {
                return;
            }
            ArrayList<StatusDecorator> list = (ArrayList<StatusDecorator>)allDecorators.get(this.viewId);
            if (list == null) {
                list = new ArrayList<StatusDecorator>(2);
                list.add(this);
                allDecorators.put(this.viewId, list);
            } else if (!list.contains((Object)this)) {
                list.add(this);
            }
        }

        public void deactivate() {
            if (this.viewId == null) {
                return;
            }
            List list = (List)allDecorators.get(this.viewId);
            if (list != null) {
                list.remove((Object)this);
                if (list.isEmpty()) {
                    allDecorators.remove(this.viewId);
                }
            }
            super.deactivate();
        }
    }
}

