/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.common.archive;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.opt4j.common.archive.BoundedArchive;
import org.opt4j.common.random.Rand;
import org.opt4j.core.Individual;
import org.opt4j.start.Constant;

public class AdaptiveGridArchive
extends BoundedArchive {
    protected boolean isInit = false;
    protected final int div;
    protected final Rand random;
    protected final Map<Long, Cell> cells = new LinkedHashMap<Long, Cell>();
    protected final List<Individual> extrema = new ArrayList<Individual>();
    protected double[] lb;
    protected double[] ub;
    protected int dim;

    @Inject
    public AdaptiveGridArchive(@Constant(value="capacity", namespace=BoundedArchive.class) int capacity, @Constant(value="div", namespace=AdaptiveGridArchive.class) int div, Rand random) {
        super(capacity);
        this.random = random;
        this.div = div;
    }

    @Override
    protected boolean updateWithNondominated(Collection<Individual> candidates) {
        if (!this.isInit && candidates.size() > 0) {
            this.init(candidates.iterator().next());
        }
        if (this.determineBounds(candidates)) {
            this.cells.clear();
            this.addToCell(this);
        }
        this.addToCell(candidates);
        boolean changed = false;
        if (this.size() + candidates.size() <= this.capacity) {
            changed = this.addCheckedIndividuals(candidates);
        } else {
            candidates.addAll(this);
            while (candidates.size() > this.capacity) {
                Cell cell = this.getMostCrowdedCell();
                ArrayList<Individual> list = new ArrayList<Individual>(cell);
                list.removeAll(this.extrema);
                Individual individual = (Individual)list.get(this.random.nextInt(list.size()));
                candidates.remove(individual);
                this.removeFromCell(individual);
            }
            this.retainAll(candidates);
            for (Individual individual : candidates) {
                if (this.contains(individual)) continue;
                changed |= this.addCheckedIndividual(individual);
            }
        }
        return changed;
    }

    protected void init(Individual individual) {
        if (!this.isInit) {
            this.dim = individual.getObjectives().size();
            this.lb = new double[this.dim];
            this.ub = new double[this.dim];
            int i = 0;
            while (i < this.dim) {
                this.lb[i] = Double.MAX_VALUE;
                this.ub[i] = Double.MIN_VALUE;
                this.extrema.add(null);
                this.extrema.add(null);
                ++i;
            }
            this.isInit = true;
        }
    }

    protected Cell getCell(Individual individual) {
        double[] obj = individual.getObjectives().array();
        int scale = 1;
        long identifier = 0L;
        int i = 0;
        while (i < obj.length) {
            double half = 1.0 / (2.0 * (double)this.div) * (this.ub[i] - this.lb[i]);
            double lbi = this.lb[i] - half;
            double ubi = this.ub[i] + half;
            double step = (ubi - lbi) / (double)this.div;
            int position = (int)Math.floor((obj[i] - lbi) / step);
            identifier += (long)(position * scale);
            scale *= this.div;
            ++i;
        }
        Cell cell = this.cells.get(identifier);
        if (cell != null) {
            return cell;
        }
        return new Cell(identifier);
    }

    protected Cell getMostCrowdedCell() {
        Cell mc = null;
        int size = 0;
        LinkedHashSet<Individual> extrema = new LinkedHashSet<Individual>(this.extrema);
        for (Cell cell : this.cells.values()) {
            int s = 0;
            assert (!cell.isEmpty());
            for (Individual individual : cell) {
                if (extrema.contains(individual)) continue;
                ++s;
            }
            if (s <= size) continue;
            size = s;
            mc = cell;
        }
        return mc;
    }

    @Override
    public boolean remove(Object o) {
        Individual individual = (Individual)o;
        this.removeFromCell(individual);
        if (this.extrema.contains(individual)) {
            int i = 0;
            while (i < this.extrema.size()) {
                if (individual.equals(this.extrema.get(i))) {
                    this.extrema.set(i, null);
                    int j = (int)Math.floor((double)i / 2.0);
                    if (i % 2 == 0) {
                        this.lb[j] = Double.MAX_VALUE;
                    } else {
                        this.ub[j] = Double.MIN_VALUE;
                    }
                }
                ++i;
            }
        }
        return super.remove(individual);
    }

    protected void addToCell(Iterable<Individual> individuals) {
        for (Individual individual : individuals) {
            Cell cell = this.getCell(individual);
            cell.add(individual);
            this.cells.put(cell.identifier, cell);
        }
    }

    protected void removeFromCell(Individual individual) {
        Cell cell = this.getCell(individual);
        cell.remove(individual);
        if (cell.isEmpty()) {
            this.cells.remove(cell.getIdentifier());
        }
    }

    protected boolean determineBounds(Collection<Individual> individuals) {
        boolean boundsChanged = false;
        for (Individual individual : individuals) {
            double[] obj = individual.getObjectives().array();
            int i = 0;
            while (i < this.dim) {
                double value = obj[i];
                if (value < this.lb[i]) {
                    boundsChanged = true;
                    this.extrema.set(2 * i, individual);
                    this.lb[i] = obj[i];
                } else if (value > this.ub[i]) {
                    boundsChanged = true;
                    this.extrema.set(2 * i + 1, individual);
                    this.ub[i] = obj[i];
                }
                ++i;
            }
        }
        return boundsChanged;
    }

    protected static class Cell
    extends LinkedHashSet<Individual> {
        private static final long serialVersionUID = 1L;
        protected final long identifier;

        public Cell(long identifier) {
            this.identifier = identifier;
        }

        public long getIdentifier() {
            return this.identifier;
        }
    }
}

