/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.common.archive;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import org.opt4j.common.archive.BoundedArchive;
import org.opt4j.core.Individual;
import org.opt4j.optimizer.ea.Crowding;
import org.opt4j.start.Constant;

public class CrowdingArchive
extends BoundedArchive {
    @Inject
    public CrowdingArchive(@Constant(value="capacity", namespace=BoundedArchive.class) int capacity) {
        super(capacity);
    }

    @Override
    protected boolean updateWithNondominated(Collection<Individual> candidates) {
        boolean changed = false;
        if (this.size() + candidates.size() <= this.capacity) {
            changed = this.addCheckedIndividuals(candidates);
        } else {
            candidates.addAll(this);
            Crowding crowding = new Crowding();
            List<Individual> list = crowding.order(crowding.getDensityValues(candidates));
            List<Individual> worst = list.subList(this.capacity, list.size());
            candidates.removeAll(worst);
            this.retainAll(candidates);
            for (Individual i : candidates) {
                if (this.contains(i)) continue;
                changed |= this.addCheckedIndividual(i);
            }
        }
        return changed;
    }
}

