/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.common.completer;

import org.opt4j.common.completer.ParallelIndividualCompleter;
import org.opt4j.common.completer.SequentialIndividualCompleter;
import org.opt4j.config.annotations.Icon;
import org.opt4j.config.annotations.Info;
import org.opt4j.config.annotations.Required;
import org.opt4j.core.optimizer.IndividualCompleter;
import org.opt4j.start.Constant;
import org.opt4j.start.Opt4JModule;

@Icon(value="icons/puzzle-blue.png")
@Info(value="The IndividualCompleter decodes and evaluates the individuals in the optimization process.")
public class IndividualCompleterModule
extends Opt4JModule {
    @Info(value="Sets the type of the individual completer.")
    protected Type type = Type.SEQUENTIAL;
    @Info(value="Sets the number of parallel processes.")
    @Required(property="type", elements={"PARALLEL"})
    @Constant(value="maxThreads", namespace=ParallelIndividualCompleter.class)
    protected int threads = 4;

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        if (threads <= 0) {
            throw new IllegalArgumentException("The number of threads must be positive: " + threads);
        }
        this.threads = threads;
    }

    @Override
    public void config() {
        switch (this.type) {
            case SEQUENTIAL: {
                this.bind(IndividualCompleter.class).to(SequentialIndividualCompleter.class).in(SINGLETON);
                break;
            }
            default: {
                this.bind(ParallelIndividualCompleter.class).in(SINGLETON);
                this.bind(IndividualCompleter.class).to(ParallelIndividualCompleter.class);
                this.addOptimizerStateListener(ParallelIndividualCompleter.class);
            }
        }
    }

    public static enum Type {
        SEQUENTIAL,
        PARALLEL;

    }
}

