/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.common.random;

import java.util.Random;
import org.opt4j.common.random.Rand;
import org.opt4j.common.random.RandomJava;
import org.opt4j.common.random.RandomMersenneTwister;
import org.opt4j.config.annotations.Icon;
import org.opt4j.config.annotations.Info;
import org.opt4j.config.annotations.Required;
import org.opt4j.start.Opt4JModule;

@Icon(value="icons/puzzle-blue.png")
@Info(value="Global random number generator for the optimization process.")
public class RandomModule
extends Opt4JModule {
    @Info(value="Seed of the random number generator.")
    @Required(property="usingSeed", elements={"true"})
    protected long seed = 0L;
    @Info(value="Use a specific seed.")
    protected boolean usingSeed = true;
    @Info(value="Type of the random number generator.")
    protected RandType type = RandType.MERSENNE_TWISTER;

    @Override
    public void config() {
        Class randomClass;
        switch (this.type) {
            case JAVA: {
                randomClass = RandomJava.class;
                break;
            }
            default: {
                randomClass = RandomMersenneTwister.class;
            }
        }
        long seed = this.seed;
        if (!this.usingSeed) {
            seed = System.currentTimeMillis();
        }
        this.bindConstant("seed", Random.class).to(seed);
        this.bind(Rand.class).to(randomClass).in(SINGLETON);
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setType(RandType type) {
        this.type = type;
    }

    public RandType getType() {
        return this.type;
    }

    public boolean isUsingSeed() {
        return this.usingSeed;
    }

    public void setUsingSeed(boolean value) {
        this.usingSeed = value;
    }

    public static enum RandType {
        JAVA,
        MERSENNE_TWISTER;

    }
}

