/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.config;

import org.opt4j.config.Property;
import org.opt4j.config.Requirement;

public class BooleanRequirement
implements Requirement {
    private final Boolean value;
    private final Property property;

    public BooleanRequirement(Property property, boolean value) {
        this.property = property;
        this.value = value;
        Class<?> type = property.getType();
        if (!type.equals(Boolean.TYPE)) {
            throw new IllegalArgumentException(property + " is not a boolean property.");
        }
    }

    @Override
    public Property getProperty() {
        return this.property;
    }

    @Override
    public boolean isFulfilled() {
        if (this.property.isActive()) {
            Object obj = this.property.getValue();
            return this.value.equals(obj);
        }
        return false;
    }
}

