/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.config;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JNode {
    protected final Node node;

    public JNode(Node node) {
        this.node = node;
    }

    public JNode(Document document, String name) {
        this.node = document.createElement(name);
    }

    public Node getNode() {
        return this.node;
    }

    public String getName() {
        return this.node.getNodeName();
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            NamedNodeMap attributes = this.node.getAttributes();
            int i = 0;
            while (i < attributes.getLength()) {
                Node attribute = attributes.item(i);
                map.put(attribute.getNodeName(), attribute.getNodeValue());
                ++i;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return map;
    }

    public String getAttribute(String attribute) {
        try {
            Element element = (Element)this.node;
            return element.getAttribute(attribute);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public boolean hasAttribute(String attribute) {
        try {
            Element element = (Element)this.node;
            if (element.hasAttribute(attribute)) {
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public JNode getChild() {
        return new JNode(this.node.getFirstChild());
    }

    public JNode getChild(String name) {
        List<JNode> list = this.getChildren();
        for (JNode node : list) {
            if (!node.getName().equalsIgnoreCase(name)) continue;
            return node;
        }
        return null;
    }

    public List<JNode> getChildren() {
        LinkedList<JNode> list = new LinkedList<JNode>();
        NodeList children = this.node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            list.add(new JNode(child));
            ++i;
        }
        return list;
    }

    public List<JNode> getChildren(String name) {
        List<JNode> list = this.getChildren();
        LinkedList<JNode> namedList = new LinkedList<JNode>();
        for (JNode node : list) {
            if (!node.getName().equalsIgnoreCase(name)) continue;
            namedList.add(node);
        }
        return namedList;
    }

    public String getText() {
        return this.node.getTextContent();
    }

    public boolean hasText() {
        return this.node.getTextContent() != null && !this.node.getTextContent().equals("");
    }

    public void setText(String text) {
        this.node.setTextContent(text);
    }

    public void setAttribute(String attribute, String value) {
        ((Element)this.node).setAttribute(attribute, value);
    }

    public JNode appendChild(String name) {
        Document document = this.node.getOwnerDocument();
        Element n = document.createElement(name);
        return this.appendChild(n);
    }

    public JNode appendChild(Node node) {
        return this.appendChild(new JNode(node));
    }

    public JNode appendChild(JNode jNode) {
        this.node.appendChild(jNode.getNode());
        return jNode;
    }

    public Document getDocument() {
        return this.node.getOwnerDocument();
    }

    public String toString() {
        return this.node.toString();
    }
}

