/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.config;

import com.google.inject.Module;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opt4j.config.JNode;
import org.opt4j.config.ModuleRegister;
import org.opt4j.config.PropertyModule;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ModuleLoader {
    protected final ModuleRegister moduleRegister;

    public ModuleLoader(ModuleRegister moduleRegister) {
        this.moduleRegister = moduleRegister;
    }

    public Collection<? extends Module> load(String filename) {
        File file = new File(filename);
        return this.load(file);
    }

    public Collection<? extends Module> load(File file) {
        ArrayList<? extends Module> modules = new ArrayList<Module>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(file);
            modules.addAll(this.get(document.getFirstChild()));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return modules;
    }

    public Collection<? extends Module> get(Node node) {
        ArrayList<Module> modules = new ArrayList<Module>();
        JNode application = new JNode(node);
        for (JNode child : application.getChildren("module")) {
            String name = child.getAttribute("class");
            try {
                Class<Module> clazz = Class.forName(name).asSubclass(Module.class);
                PropertyModule module = this.moduleRegister.get(clazz);
                module.setConfiguration(child.getNode());
                modules.add(module.getModule());
            }
            catch (ClassNotFoundException e) {
                System.err.println("Class " + name + " not found.");
            }
        }
        return modules;
    }
}

