/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.domination;

import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.opt4j.config.annotations.Info;
import org.opt4j.core.domination.ConstraintChecker;
import org.opt4j.core.domination.ConstraintCheckerImpl;
import org.opt4j.core.domination.ConstraintDomination;
import org.opt4j.core.domination.DominationStrategy;
import org.opt4j.core.domination.GoalAttainmentDomination;
import org.opt4j.core.domination.ParetoDomination;
import org.opt4j.start.Opt4JModule;

@Info(value="Constraint Domination")
public class ConstraintDominationModule
extends Opt4JModule {
    @Info(value="Strategy when examining two feasible solutions")
    protected Strategy strategyForFeasibleSolutions = Strategy.ParetoDomination;
    protected Class<? extends DominationStrategy> strategyForFeasibleSolutionsClass = ParetoDomination.class;

    public Strategy getStrategyForFeasibleSolutions() {
        return this.strategyForFeasibleSolutions;
    }

    public void setStrategyForFeasibleSolutions(Strategy strategyForFeasibleSolutions) {
        this.strategyForFeasibleSolutions = strategyForFeasibleSolutions;
    }

    @Override
    protected void config() {
        this.bind(DominationStrategy.class).to(ConstraintDomination.class).in(SINGLETON);
        switch (this.strategyForFeasibleSolutions) {
            case GoalAttainmentDomination: {
                this.strategyForFeasibleSolutionsClass = GoalAttainmentDomination.class;
                break;
            }
        }
        this.bind(DominationStrategy.class).annotatedWith((Annotation)Names.named((String)"StrategyForFeasibleObjectives")).to(this.strategyForFeasibleSolutionsClass);
        this.bind(ConstraintChecker.class).to(ConstraintCheckerImpl.class).in(SINGLETON);
        this.addIndividualStateListener(ConstraintCheckerImpl.class);
    }

    public static enum Strategy {
        ParetoDomination,
        GoalAttainmentDomination;

    }
}

