/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.optimizer;

import com.google.inject.Inject;
import org.opt4j.core.optimizer.Optimizer;
import org.opt4j.core.optimizer.StopException;
import org.opt4j.core.optimizer.TerminationException;

public class Bootstrap {
    protected final Optimizer optimizer;

    @Inject
    public Bootstrap(Optimizer optimizer) {
        this.optimizer = optimizer;
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public void execute() {
        this.optimizer.startOptimization();
        try {
            try {
                this.optimizer.optimize();
            }
            catch (StopException e) {
                System.out.println("Optimization stopped.");
                this.optimizer.stopOptimization();
            }
            catch (TerminationException e) {
                System.err.println("Optimization terminated.");
                this.optimizer.stopOptimization();
            }
        }
        finally {
            this.optimizer.stopOptimization();
        }
    }
}

