/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.optimizer;

import com.google.inject.Singleton;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opt4j.core.optimizer.ControlListener;
import org.opt4j.core.optimizer.StopException;
import org.opt4j.core.optimizer.TerminationException;

@Singleton
public class Control {
    protected State state = State.RUNNING;
    protected final Set<ControlListener> listeners = new CopyOnWriteArraySet<ControlListener>();

    public synchronized void doStart() {
        if (this.state.isStartable()) {
            this.setState(State.RUNNING);
        }
    }

    public synchronized void doPause() {
        if (this.state.isPausable()) {
            this.setState(State.PAUSED);
        }
    }

    public synchronized void doStop() {
        if (this.state.isStoppable()) {
            this.setState(State.STOPPED);
        }
    }

    public synchronized void doTerminate() {
        this.setState(State.TERMINATED);
    }

    public synchronized boolean isRunning() {
        return this.state == State.RUNNING;
    }

    public synchronized boolean isPaused() {
        return this.state == State.PAUSED;
    }

    public synchronized boolean isStopped() {
        return this.state == State.STOPPED;
    }

    public synchronized boolean isTerminated() {
        return this.state == State.TERMINATED;
    }

    public synchronized void checkpoint() throws TerminationException {
        while (this.state == State.PAUSED) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.state == State.TERMINATED) {
            throw new TerminationException();
        }
    }

    public synchronized void checkpointStop() throws TerminationException, StopException {
        this.checkpoint();
        if (this.state == State.STOPPED) {
            throw new StopException();
        }
    }

    public State getState() {
        return this.state;
    }

    protected synchronized void setState(State state) {
        boolean changed;
        boolean bl = changed = this.state != state;
        if (changed) {
            this.state = state;
            this.notifyAll();
            for (ControlListener listener : this.listeners) {
                listener.stateChanged(state);
            }
        }
    }

    public void addListener(ControlListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ControlListener listener) {
        this.listeners.remove(listener);
    }

    public static enum State {
        RUNNING,
        PAUSED,
        STOPPED,
        TERMINATED;


        public boolean isStartable() {
            return this == PAUSED;
        }

        public boolean isPausable() {
            return this == RUNNING;
        }

        public boolean isStoppable() {
            return this != TERMINATED;
        }
    }
}

