/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizer.ea;

import com.google.inject.Inject;
import java.util.Collection;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualFactory;
import org.opt4j.core.optimizer.AbstractOptimizer;
import org.opt4j.core.optimizer.Archive;
import org.opt4j.core.optimizer.Control;
import org.opt4j.core.optimizer.IndividualCompleter;
import org.opt4j.core.optimizer.Iteration;
import org.opt4j.core.optimizer.Population;
import org.opt4j.core.optimizer.StopException;
import org.opt4j.core.optimizer.TerminationException;
import org.opt4j.optimizer.ea.Mating;
import org.opt4j.optimizer.ea.Selector;
import org.opt4j.start.Constant;

public class EvolutionaryAlgorithm
extends AbstractOptimizer {
    protected final int alpha;
    protected final int lambda;
    protected final int mu;
    protected final Selector selector;
    protected final Mating mating;
    protected final IndividualFactory individualFactory;

    @Inject
    public EvolutionaryAlgorithm(Population population, Archive archive, IndividualFactory individualFactory, IndividualCompleter completer, Control control, Selector selector, Mating mating, Iteration iteration, @Constant(value="alpha", namespace=EvolutionaryAlgorithm.class) int alpha, @Constant(value="mu", namespace=EvolutionaryAlgorithm.class) int mu, @Constant(value="lambda", namespace=EvolutionaryAlgorithm.class) int lambda) {
        super(population, archive, completer, control, iteration);
        this.selector = selector;
        this.mating = mating;
        this.alpha = alpha;
        this.mu = mu;
        this.lambda = lambda;
        this.individualFactory = individualFactory;
        if (alpha <= 0) {
            throw new IllegalArgumentException("Invalid alpha: " + alpha);
        }
        if (mu <= 0) {
            throw new IllegalArgumentException("Invalid mu: " + mu);
        }
        if (lambda <= 0) {
            throw new IllegalArgumentException("Invalid lambda: " + lambda);
        }
    }

    @Override
    public void optimize() throws TerminationException, StopException {
        this.selector.init(this.alpha + this.lambda);
        while (this.iteration.value() < this.iteration.max()) {
            int offspringCount = this.lambda;
            while (this.population.size() < this.alpha && offspringCount > 0) {
                this.population.add(this.individualFactory.create());
                --offspringCount;
            }
            if (offspringCount > 0) {
                if (offspringCount < this.lambda) {
                    this.completer.complete(this.population);
                }
                Collection<Individual> parents = this.selector.getParents(this.mu, this.population);
                Collection<Individual> offspring = this.mating.getOffspring(offspringCount, parents);
                this.population.addAll((Collection<? extends Individual>)offspring);
            }
            this.completer.complete(this.population);
            if (this.population.size() > this.alpha) {
                Collection<Individual> lames = this.selector.getLames(this.population.size() - this.alpha, this.population);
                this.population.removeAll(lames);
            }
            this.nextIteration();
        }
    }
}

