/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizer.ea;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.opt4j.common.random.Rand;
import org.opt4j.core.Individual;
import org.opt4j.core.Objectives;
import org.opt4j.optimizer.ea.FrontDensityIndicator;
import org.opt4j.optimizer.ea.Selector;
import org.opt4j.start.Constant;

public class Nsga2
implements Selector {
    protected final Random random;
    protected final int tournament;
    protected final FrontDensityIndicator indicator;

    @Inject
    public Nsga2(Rand random, @Constant(value="tournament", namespace=Nsga2.class) int tournament, FrontDensityIndicator indicator) {
        this.random = random;
        this.tournament = tournament;
        this.indicator = indicator;
    }

    @Override
    public void init(int maxsize) {
    }

    @Override
    public Collection<Individual> getParents(int mu, Collection<Individual> population) {
        ArrayList<Individual> all = new ArrayList<Individual>(population);
        ArrayList<Individual> parents = new ArrayList<Individual>();
        List<List<Individual>> fronts = this.fronts(all);
        Map<Individual, Integer> rank = this.getRank(fronts);
        HashMap<Individual, Double> distance = new HashMap<Individual, Double>();
        int size = all.size();
        int i = 0;
        while (i < mu) {
            Individual winner = (Individual)all.get(this.random.nextInt(size));
            int t = 0;
            while (t < this.tournament) {
                Individual opponent = (Individual)all.get(this.random.nextInt(size));
                if (rank.get(opponent) < rank.get(winner) || opponent == winner) {
                    winner = opponent;
                } else if (rank.get(opponent) == rank.get(winner)) {
                    if (!distance.containsKey(winner)) {
                        List<Individual> front = fronts.get(rank.get(winner));
                        distance.putAll(this.indicator.getDensityValues(front));
                    }
                    if ((Double)distance.get(opponent) > (Double)distance.get(winner)) {
                        winner = opponent;
                    }
                }
                ++t;
            }
            parents.add(winner);
            ++i;
        }
        return parents;
    }

    @Override
    public Collection<Individual> getLames(int n, Collection<Individual> population) {
        ArrayList<Individual> lames = new ArrayList<Individual>();
        int size = n;
        List<List<Individual>> fronts = this.fronts(population);
        Collections.reverse(fronts);
        for (List<Individual> front : fronts) {
            if (lames.size() + front.size() < size) {
                lames.addAll(front);
                continue;
            }
            final Map<Individual, Double> density = this.indicator.getDensityValues(front);
            Collections.sort(front, new Comparator<Individual>(){

                @Override
                public int compare(Individual o1, Individual o2) {
                    return ((Double)density.get(o1)).compareTo((Double)density.get(o2));
                }
            });
            lames.addAll(front.subList(0, size - lames.size()));
        }
        return lames;
    }

    protected Map<Individual, Integer> getRank(List<List<Individual>> fronts) {
        HashMap<Individual, Integer> ranks = new HashMap<Individual, Integer>();
        int i = 0;
        while (i < fronts.size()) {
            for (Individual p : fronts.get(i)) {
                ranks.put(p, i);
            }
            ++i;
        }
        return ranks;
    }

    public List<List<Individual>> fronts(Collection<Individual> individuals) {
        ArrayList<Individual> pop = new ArrayList<Individual>(individuals);
        HashMap<Individual, Integer> id = new HashMap<Individual, Integer>();
        int i = 0;
        while (i < pop.size()) {
            id.put((Individual)pop.get(i), i);
            ++i;
        }
        ArrayList<List<Individual>> fronts = new ArrayList<List<Individual>>();
        HashMap S = new HashMap();
        int[] n = new int[pop.size()];
        for (Individual e : pop) {
            S.put(e, new ArrayList());
            n[((Integer)id.get((Object)e)).intValue()] = 0;
        }
        int i2 = 0;
        while (i2 < pop.size()) {
            int j = i2 + 1;
            while (j < pop.size()) {
                Objectives qo;
                Individual p = (Individual)pop.get(i2);
                Individual q = (Individual)pop.get(j);
                Objectives po = p.getObjectives();
                if (po.dominates(qo = q.getObjectives())) {
                    ((List)S.get(p)).add(q);
                    int n2 = (Integer)id.get(q);
                    n[n2] = n[n2] + 1;
                } else if (qo.dominates(po)) {
                    ((List)S.get(q)).add(p);
                    int n3 = (Integer)id.get(p);
                    n[n3] = n[n3] + 1;
                }
                ++j;
            }
            ++i2;
        }
        ArrayList<Individual> f1 = new ArrayList<Individual>();
        for (Individual i3 : pop) {
            if (n[(Integer)id.get(i3)] != 0) continue;
            f1.add(i3);
        }
        fronts.add(f1);
        ArrayList<Individual> fi = f1;
        while (!fi.isEmpty()) {
            ArrayList<Individual> h = new ArrayList<Individual>();
            for (Individual p : fi) {
                for (Individual q : (List)S.get(p)) {
                    int n4 = (Integer)id.get(q);
                    n[n4] = n[n4] - 1;
                    if (n[(Integer)id.get(q)] != 0) continue;
                    h.add(q);
                }
            }
            fronts.add(h);
            fi = h;
        }
        return fronts;
    }
}

