/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizer.mopso;

import com.google.inject.Inject;
import org.opt4j.common.random.Rand;
import org.opt4j.operator.mutate.MutateDoubleElementwise;
import org.opt4j.operator.normalize.NormalizeDouble;
import org.opt4j.optimizer.mopso.MutateDoubleNonUniform;
import org.opt4j.start.Constant;

public class MutateDoubleUniform
extends MutateDoubleElementwise {
    protected final double perturbation;

    @Inject
    public MutateDoubleUniform(Rand random, NormalizeDouble normalize, @Constant(value="perturbation", namespace=MutateDoubleNonUniform.class) double perturbation) {
        super(random, normalize);
        this.perturbation = perturbation;
    }

    @Override
    protected double mutateElement(double x, double lb, double ub, double p) {
        if (this.random.nextDouble() < p) {
            double v = (this.random.nextDouble() - 0.5) * this.perturbation;
            x += v;
        }
        return x;
    }
}

