/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.quality.util;

import de.uka.ipd.sdq.stoex.AbstractNamedReference;
import de.uka.ipd.sdq.stoex.NamespaceReference;
import de.uka.ipd.sdq.stoex.VariableReference;
import de.uka.ipd.sdq.stoex.util.StoexSwitch;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.parameter.VariableCharacterisation;
import org.palladiosimulator.pcm.parameter.VariableCharacterisationType;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.CollectionDataType;
import org.palladiosimulator.pcm.repository.CompositeDataType;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.PrimitiveDataType;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.util.RepositorySwitch;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.StartAction;

public class PCMUtil {
    private static final Logger LOGGER = Logger.getLogger(PCMUtil.class.getCanonicalName());
    private static final StoexSwitch<String> anr2qnConverter = new StoexSwitch<String>(){

        public String caseNamespaceReference(NamespaceReference object) {
            String result = object.getReferenceName();
            if (object.getInnerReference_NamespaceReference() != null) {
                result = String.valueOf(result) + "." + (String)this.doSwitch((EObject)object.getInnerReference_NamespaceReference());
            }
            return result;
        }

        public String caseVariableReference(VariableReference object) {
            return object.getReferenceName();
        }

        public String caseAbstractNamedReference(AbstractNamedReference object) {
            throw new IllegalArgumentException("The provided variable reference is not supported by this implementation.");
        }
    };

    public static String getQualifiedCollectionNoE(Parameter parameter) {
        if (!(parameter.getDataType__Parameter() instanceof CollectionDataType)) {
            String msg = "Requested number of elements for a parameter which is not a collection data type and does not have a definition of number of elements.";
            LOGGER.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        return String.valueOf(parameter.getParameterName()) + "." + VariableCharacterisationType.NUMBER_OF_ELEMENTS;
    }

    public static String getQualifiedName(Parameter parameter) {
        if (parameter == null) {
            return "<null>";
        }
        return parameter.getParameterName();
    }

    public static String getQualifiedName(VariableCharacterisation variableCharacterization) {
        if (variableCharacterization == null) {
            return "<null>";
        }
        return String.valueOf(PCMUtil.getQualifiedName(variableCharacterization.getVariableUsage_VariableCharacterisation())) + "." + variableCharacterization.getType();
    }

    public static String getQualifiedName(VariableUsage variableUsage) {
        if (variableUsage == null) {
            return "<null>";
        }
        return PCMUtil.getQualifiedName(variableUsage.getNamedReference__VariableUsage());
    }

    public static String getQualifiedName(AbstractNamedReference reference) {
        if (reference == null) {
            return "";
        }
        return (String)anr2qnConverter.doSwitch((EObject)reference);
    }

    public static List<Parameter> getParameters(ResourceDemandingSEFF rdseff) {
        LinkedList<Parameter> parameters = new LinkedList<Parameter>();
        if (rdseff.getDescribedService__SEFF() != null) {
            if (rdseff.getDescribedService__SEFF() instanceof OperationSignature) {
                parameters.addAll((Collection<Parameter>)((OperationSignature)rdseff.getDescribedService__SEFF()).getParameters__OperationSignature());
            } else if (rdseff.getDescribedService__SEFF() instanceof InfrastructureSignature) {
                parameters.addAll((Collection<Parameter>)((InfrastructureSignature)rdseff.getDescribedService__SEFF()).getParameters__InfrastructureSignature());
            } else {
                throw new IllegalArgumentException("The provided ResourceDemandingSEFF did not describe a known signature. Unable to determine input parameters and to continue.");
            }
        }
        return parameters;
    }

    public static StartAction getInitialAction(ResourceDemandingBehaviour behaivor) {
        for (AbstractAction action : behaivor.getSteps_Behaviour()) {
            if (action.getPredecessor_AbstractAction() != null || !(action instanceof StartAction)) continue;
            return (StartAction)action;
        }
        String msg = "The model was not valid. A ResourceDemandingBehavior must contain exactly one StartAction. That StartAction must not contain a predecessor. Fix the model.";
        LOGGER.severe(msg);
        throw new IllegalArgumentException(msg);
    }

    public static String prettyPrint(AbstractAction action) {
        if (action == null) {
            return "<null>";
        }
        return String.valueOf(action.getEntityName()) + " [ID:" + action.getId() + "] <" + action.eClass().getName() + ">";
    }

    public static String prettyPrint(RepositoryComponent component) {
        return String.valueOf(component.getEntityName()) + "[ID:" + component.getId() + "] <" + component.eClass().getName() + ">";
    }

    public static String prettyPrint(OperationSignature signature) {
        if (signature == null) {
            return "<null>";
        }
        String result = String.valueOf(PCMUtil.prettyPrint(signature.getReturnType__OperationSignature())) + " " + signature.getInterface__OperationSignature().getEntityName() + "::" + signature.getEntityName() + "(";
        for (Parameter parameter : signature.getParameters__OperationSignature()) {
            result = String.valueOf(result) + PCMUtil.prettyPrint(parameter.getDataType__Parameter()) + " " + parameter.getParameterName() + ", ";
        }
        result.substring(0, result.length() - 2);
        result = String.valueOf(result) + ") [ID: " + signature.getId() + "]";
        return result;
    }

    public static String prettyPrint(InfrastructureSignature signature) {
        if (signature == null || signature.getInfrastructureInterface__InfrastructureSignature() == null) {
            return "<null>";
        }
        String result = String.valueOf(signature.getInfrastructureInterface__InfrastructureSignature().getEntityName()) + "::" + signature.getEntityName() + "(";
        for (Parameter parameter : signature.getParameters__InfrastructureSignature()) {
            result = String.valueOf(result) + parameter.getDataType__Parameter() + " " + parameter.getParameterName() + ", ";
        }
        result.substring(0, result.length() - 2);
        result = String.valueOf(result) + ") [ID: " + signature.getId() + "]";
        return result;
    }

    public static String prettyPrint(RequiredRole requiredRole) {
        if (requiredRole == null) {
            return "<null>";
        }
        return String.valueOf(requiredRole.getEntityName()) + " [ID:" + requiredRole.getId() + "]";
    }

    public static String prettyPrint(DataType dataType) {
        if (dataType == null) {
            return "void";
        }
        return (String)new RepositorySwitch<String>(){

            public String caseCollectionDataType(CollectionDataType object) {
                return String.valueOf(object.getEntityName()) + " [ID:" + object.getId() + "]";
            }

            public String caseCompositeDataType(CompositeDataType object) {
                return String.valueOf(object.getEntityName()) + " [ID:" + object.getId() + "]";
            }

            public String casePrimitiveDataType(PrimitiveDataType object) {
                return object.getType().getName();
            }

            public String caseDataType(DataType object) {
                String msg = "Unknown data type experienced. eType was: " + object.eClass().getName();
                LOGGER.severe(msg);
                throw new IllegalArgumentException(msg);
            }
        }.doSwitch((EObject)dataType);
    }

    public static String prettyPrint(List<VariableUsage> usages) {
        String result = "";
        for (VariableUsage vu : usages) {
            result = String.valueOf(result) + PCMUtil.getQualifiedName(vu) + "(";
            for (VariableCharacterisation vc : vu.getVariableCharacterisation_VariableUsage()) {
                result = String.valueOf(result) + vc.getType().getName() + ",";
            }
            result.substring(0, result.length() - 2);
            result = String.valueOf(result) + ")";
        }
        return result;
    }
}

