/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.commons.dialogs.stoex;

import de.uka.ipd.sdq.errorhandling.IIssue;
import de.uka.ipd.sdq.stoex.Expression;
import de.uka.ipd.sdq.stoex.RandomVariable;
import de.uka.ipd.sdq.stoex.analyser.exceptions.ExpectedTypeMismatchIssue;
import de.uka.ipd.sdq.stoex.analyser.visitors.ExpressionInferTypeVisitor;
import de.uka.ipd.sdq.stoex.analyser.visitors.NonProbabilisticExpressionInferTypeVisitor;
import de.uka.ipd.sdq.stoex.analyser.visitors.TypeCheckVisitor;
import de.uka.ipd.sdq.stoex.analyser.visitors.TypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Shell;
import org.palladiosimulator.editors.commons.dialogs.stoex.AbstractGrammerBasedEditDialog;
import org.palladiosimulator.editors.commons.dialogs.stoex.ITokenMapper;
import org.palladiosimulator.editors.commons.dialogs.stoex.StoExParserException;
import org.palladiosimulator.editors.commons.dialogs.stoex.StoExTokenMapper;
import org.palladiosimulator.pcm.parameter.VariableCharacterisation;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.EventType;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.stochasticexpressions.parser.MyPCMStoExLexer;
import org.palladiosimulator.pcm.stochasticexpressions.parser.MyPCMStoExParser;
import org.palladiosimulator.pcm.stochasticexpressions.parser.PCMStoExLexer;

public class StochasticExpressionEditDialog
extends AbstractGrammerBasedEditDialog {
    private final TypeEnum expectedType;

    public StochasticExpressionEditDialog(Shell parent, TypeEnum expectedType) {
        super(parent);
        this.expectedType = expectedType;
    }

    public StochasticExpressionEditDialog(Shell parent, TypeEnum expectedType, Parameter[] context) {
        super(parent, context);
        this.expectedType = expectedType;
    }

    public StochasticExpressionEditDialog(Shell parent, TypeEnum expectedType, EObject contextObject) {
        super(parent);
        this.expectedType = expectedType;
        this.context = this.getContext(contextObject);
    }

    public void setInitialExpression(RandomVariable ex) {
        this.newText = ex.getSpecification();
    }

    public Expression getResult() {
        return (Expression)super.getResult();
    }

    @Override
    public String getResultText() {
        return super.getResultText();
    }

    @Override
    protected String getInitialText() {
        return "";
    }

    @Override
    protected Lexer getLexer(String text) {
        return new MyPCMStoExLexer((CharStream)new ANTLRStringStream(text));
    }

    @Override
    protected String getTitle() {
        return "Edit stochastic expression";
    }

    @Override
    protected EObject parse(Lexer lexer) throws RecognitionException, StoExParserException {
        MyPCMStoExParser parser = new MyPCMStoExParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        Expression result = parser.expression();
        ArrayList<IIssue> errorList = new ArrayList<IIssue>();
        errorList.addAll(((MyPCMStoExLexer)lexer).getErrors());
        errorList.addAll(parser.getErrors());
        if (errorList.size() == 0) {
            NonProbabilisticExpressionInferTypeVisitor typeVisitor = new NonProbabilisticExpressionInferTypeVisitor();
            typeVisitor.doSwitch((EObject)result);
            errorList.addAll(this.checkTypes((EObject)result, typeVisitor));
            errorList.addAll(this.assertType((EObject)result, (ExpressionInferTypeVisitor)typeVisitor, this.expectedType));
        }
        if (errorList.size() > 0) {
            throw new StoExParserException(errorList);
        }
        return result;
    }

    private Collection<? extends IIssue> assertType(EObject result, ExpressionInferTypeVisitor typeVisitor, TypeEnum expectedType) {
        if (!TypeCheckVisitor.typesCompatible((TypeEnum)expectedType, (TypeEnum)typeVisitor.getType((Expression)result))) {
            return Collections.singletonList(new ExpectedTypeMismatchIssue(expectedType, typeVisitor.getType((Expression)result)));
        }
        return Collections.emptyList();
    }

    private Collection<IIssue> checkTypes(EObject result, NonProbabilisticExpressionInferTypeVisitor typeVisitor) {
        TypeCheckVisitor typeChecker = new TypeCheckVisitor(typeVisitor);
        typeChecker.doSwitch(result);
        TreeIterator iterator = result.eAllContents();
        while (iterator.hasNext()) {
            EObject treeNode = (EObject)iterator.next();
            typeChecker.doSwitch(treeNode);
        }
        return typeChecker.getIssues();
    }

    protected Class<PCMStoExLexer> getLexerClass() {
        return PCMStoExLexer.class;
    }

    @Override
    protected ITokenMapper getTokenMapper() {
        return new StoExTokenMapper();
    }

    public static TypeEnum getTypeFromVariableCharacterisation(VariableCharacterisation ch) {
        switch (ch.getType()) {
            case NUMBER_OF_ELEMENTS: 
            case BYTESIZE: {
                return TypeEnum.INT;
            }
        }
        return TypeEnum.ANY;
    }

    private Parameter[] getContext(EObject rv) {
        Object[] parameters = new Parameter[]{};
        ResourceDemandingSEFF seff = this.getSEFF(rv);
        if (seff != null && seff.getDescribedService__SEFF() != null) {
            EventType eventType;
            if (seff.getDescribedService__SEFF() instanceof OperationSignature) {
                OperationSignature signature = (OperationSignature)seff.getDescribedService__SEFF();
                parameters = (Parameter[])signature.getParameters__OperationSignature().toArray(parameters);
            } else if (seff.getDescribedService__SEFF() instanceof EventType && (eventType = (EventType)seff.getDescribedService__SEFF()).getParameter__EventType() != null) {
                parameters = new Parameter[]{eventType.getParameter__EventType()};
            }
            ExternalCallAction eca = this.getParentCallAction(rv);
            if (eca != null && this.isOutputCharacterisation(eca, rv) && eca.getCalledService_ExternalService() != null && eca.getCalledService_ExternalService().getReturnType__OperationSignature() != null) {
                Parameter[] parametersWithReturn = new Parameter[parameters.length + 1];
                System.arraycopy(parameters, 0, parametersWithReturn, 0, parameters.length);
                parametersWithReturn[parameters.length] = RepositoryFactory.eINSTANCE.createParameter();
                parametersWithReturn[parameters.length].setDataType__Parameter(eca.getCalledService_ExternalService().getReturnType__OperationSignature());
                parametersWithReturn[parameters.length].setParameterName("RETURN");
                parameters = parametersWithReturn;
            }
        }
        return parameters;
    }

    private boolean isOutputCharacterisation(ExternalCallAction eca, EObject rv) {
        for (VariableUsage vu : eca.getReturnVariableUsage__CallReturnAction()) {
            if (!vu.getVariableCharacterisation_VariableUsage().contains((Object)rv)) continue;
            return true;
        }
        return false;
    }

    private ResourceDemandingSEFF getSEFF(EObject a) {
        EObject container = a;
        while (container != null && !(container instanceof ResourceDemandingSEFF)) {
            container = container.eContainer();
        }
        if (container == null || !(container instanceof ResourceDemandingSEFF)) {
            return null;
        }
        ResourceDemandingSEFF seff = (ResourceDemandingSEFF)container;
        return seff;
    }

    private ExternalCallAction getParentCallAction(EObject a) {
        EObject container = a;
        while (!(container instanceof ResourceDemandingSEFF) && !(container instanceof ExternalCallAction)) {
            container = container.eContainer();
        }
        if (!(container instanceof ExternalCallAction)) {
            return null;
        }
        ExternalCallAction call = (ExternalCallAction)container;
        return call;
    }
}

