/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.commons.tabs;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class EMFPropertyTextEdit
implements IDisposable {
    private TabbedPropertySheetWidgetFactory factory;
    private Text valueText;
    private Listener listener;
    private String labelText;
    protected TransactionalEditingDomain editingDomain = null;
    private EObject element;
    private EStructuralFeature attribute;
    private EMFPropertyTextEdit predecessor;
    private EContentAdapter listeningAdapter;
    private Composite composite;

    public EMFPropertyTextEdit(Composite parentForm, String labelText, EStructuralFeature attribute, TabbedPropertySheetWidgetFactory factory, EMFPropertyTextEdit predecessor) {
        this.factory = factory;
        this.labelText = labelText;
        this.attribute = attribute;
        this.predecessor = predecessor;
        this.composite = parentForm;
        this.init();
    }

    private void init() {
        this.createTextField();
        this.createDisplayLabel();
        this.addChangeListener();
    }

    private void addChangeListener() {
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: {
                        if (event.character != '\r') break;
                        EMFPropertyTextEdit.this.textChanged((Control)event.widget);
                        break;
                    }
                    case 16: {
                        EMFPropertyTextEdit.this.textChanged((Control)event.widget);
                    }
                }
            }
        };
        this.valueText.addListener(1, this.listener);
        this.valueText.addListener(16, this.listener);
        this.valueText.addListener(24, this.listener);
    }

    private void createDisplayLabel() {
        CLabel valueLabel = this.factory.createCLabel(this.composite, String.valueOf(this.labelText) + ":");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.valueText, -5);
        data.top = new FormAttachment((Control)this.valueText, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
    }

    private void createTextField() {
        this.valueText = this.factory.createText(this.composite, "");
        FormData data = new FormData();
        if (this.predecessor == null) {
            data.top = new FormAttachment(0, 0);
            data.left = new FormAttachment(0, 85);
            data.right = new FormAttachment(100, 0);
        } else {
            data.top = new FormAttachment((Control)this.predecessor.getValueText(), 4, 1024);
            data.left = new FormAttachment((Control)this.predecessor.getValueText(), 0, 16384);
            data.right = new FormAttachment((Control)this.predecessor.getValueText(), 0, 131072);
        }
        this.valueText.setLayoutData((Object)data);
    }

    private Text getValueText() {
        return this.valueText;
    }

    public void setEObject(EObject object) {
        this.editingDomain = TransactionUtil.getEditingDomain((EObject)object);
        this.element = object;
        this.listeningAdapter = new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                if (notification.getEventType() == 1 && notification.getFeature().equals(EMFPropertyTextEdit.this.attribute) && !EMFPropertyTextEdit.this.valueText.getText().equals(EMFPropertyTextEdit.this.element.eGet(EMFPropertyTextEdit.this.attribute))) {
                    EMFPropertyTextEdit.this.valueText.setText((String)EMFPropertyTextEdit.this.element.eGet(EMFPropertyTextEdit.this.attribute));
                }
            }
        };
        object.eAdapters().add((Object)this.listeningAdapter);
        String newValue = this.element.eGet(this.attribute) == null ? "" : (String)this.element.eGet(this.attribute);
        this.valueText.setText(newValue);
    }

    private void textChanged(Control control) {
        RecordingCommand recCommand = new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                EMFPropertyTextEdit.this.element.eSet(EMFPropertyTextEdit.this.attribute, (Object)EMFPropertyTextEdit.this.valueText.getText());
            }
        };
        if (!this.valueText.getText().equals(this.element.eGet(this.attribute))) {
            recCommand.setDescription("Edit Component Property");
            recCommand.setLabel("Set " + this.attribute.getName());
            this.editingDomain.getCommandStack().execute((Command)recCommand);
        }
    }

    public void dispose() {
        this.element.eAdapters().remove((Object)this.listeningAdapter);
        this.valueText.removeListener(1, this.listener);
        this.valueText.removeListener(16, this.listener);
        this.valueText.removeListener(24, this.listener);
    }
}

