/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.sirius.custom.externaljavaactions;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.ui.PlatformUI;
import org.modelversioning.emfprofile.Stereotype;
import org.palladiosimulator.architecturaltemplates.ui.dialogs.RoleStereotypeSelectionDialog;
import org.palladiosimulator.mdsdprofiles.api.StereotypeAPI;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;

public class AddATRoleAction
implements IExternalJavaAction {
    private static final String DIALOG_MESSAGE = "Select the AT role to be bound to the ";

    public void execute(Collection<? extends EObject> selections, Map<String, Object> parameters) {
        EObject selection = selections.iterator().next();
        LinkedList<Stereotype> unapplyedStereotypes = new LinkedList<Stereotype>();
        for (Stereotype stereotype : StereotypeAPI.getApplicableStereotypes((EObject)selection)) {
            if (StereotypeAPI.isStereotypeApplied((EObject)selection, (String)stereotype.getName())) continue;
            unapplyedStereotypes.add(stereotype);
        }
        RoleStereotypeSelectionDialog dialog = new RoleStereotypeSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.setMessage(DIALOG_MESSAGE + selection.eClass().getName());
        dialog.setElements((Object[])unapplyedStereotypes.toArray(new Stereotype[0]));
        if (dialog.open() != 0) {
            return;
        }
        Stereotype selectedRoleStereotype = dialog.getResultRoleStereotype();
        StereotypeAPI.applyStereotype((EObject)selection, (Stereotype)selectedRoleStereotype);
    }

    public boolean canExecute(Collection<? extends EObject> selections) {
        if (selections.size() != 1) {
            return false;
        }
        Iterator<? extends EObject> iterator = selections.iterator();
        if (iterator.hasNext()) {
            EObject object = iterator.next();
            return object instanceof AssemblyContext || object instanceof ResourceContainer;
        }
        return false;
    }
}

