/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.sirius.services;

import java.util.Collection;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.ui.PlatformUI;
import org.modelversioning.emfprofile.Stereotype;
import org.modelversioning.emfprofileapplication.ProfileImport;
import org.modelversioning.emfprofileapplication.StereotypeApplication;
import org.palladiosimulator.architecturaltemplates.api.ArchitecturalTemplateAPI;
import org.palladiosimulator.mdsdprofiles.api.StereotypeAPI;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.stochasticexpressions.parser.MyPCMStoExLexer;
import org.palladiosimulator.pcm.stochasticexpressions.parser.MyPCMStoExParser;

public class PCMServices {
    private static final String PARSER_ERROR_TITLE = "Error parsing expression";
    private static final String PARSER_ERROR_MESSAGE = "The entered stochastic expression is invalid.";
    private static final String PARAMETER_VALUE_LITERAL_DIALOG_TITLE = "Enter value literal";
    private static final String PARAMETER_VALUE_LITERAL_DIALOG_MESSAGE = "Please enter a literal to set the parameter";

    public Collection<StereotypeApplication> getStereotypeApplications(EObject eObject) {
        return StereotypeAPI.getStereotypeApplications((EObject)eObject);
    }

    public boolean isRole(StereotypeApplication stereotypeApplication) {
        return ArchitecturalTemplateAPI.isRole((Stereotype)stereotypeApplication.getStereotype());
    }

    public boolean isSystemRole(StereotypeApplication stereotypeApplication) {
        return ArchitecturalTemplateAPI.isSystemRole((Stereotype)stereotypeApplication.getStereotype());
    }

    public void queryAndSetParameterValue(EStructuralFeature parameter, EObject owningEObject) {
        InputDialog inputDialog = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), PARAMETER_VALUE_LITERAL_DIALOG_TITLE, PARAMETER_VALUE_LITERAL_DIALOG_MESSAGE, null, null);
        if (inputDialog.open() == 0) {
            this.setParameterValue(parameter, owningEObject, inputDialog.getValue());
        }
    }

    public void setParameterValue(EStructuralFeature parameter, EObject owningEObject, String valueLiteral) {
        EClassifier eType = parameter.getEType();
        Object value = null;
        if (valueLiteral == null && eType != null) {
            value = parameter.isMany() ? null : eType.getDefaultValue();
        } else if (eType instanceof EDataType) {
            EFactory factory = eType.getEPackage().getEFactoryInstance();
            EDataType eDataType = (EDataType)eType;
            if (eDataType.isSerializable()) {
                try {
                    value = factory.createFromString(eDataType, valueLiteral);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        owningEObject.eSet(parameter, value);
    }

    public Collection<EStructuralFeature> getParameters(Stereotype stereotype) {
        return StereotypeAPI.getParameters((Stereotype)stereotype);
    }

    public Collection<StereotypeApplication> getRoleApplications(EObject eObject) {
        return ArchitecturalTemplateAPI.getRoleApplications((EObject)eObject);
    }

    public Collection<StereotypeApplication> getStereotypeApplicationsWithoutRoles(EObject eObject) {
        return ArchitecturalTemplateAPI.getStereotypeApplicationsWithoutRoles((EObject)eObject);
    }

    public Collection<ProfileImport> getProfileImports(EObject eObject) {
        return ArchitecturalTemplateAPI.getProfileImports((EObject)eObject);
    }

    public boolean hasRoles(EObject object) {
        return ArchitecturalTemplateAPI.hasRoles((EObject)object);
    }

    public EObject editPCMRandomVariable(EObject pcmRandomVariable, String expressionString) {
        if (!(pcmRandomVariable instanceof PCMRandomVariable)) {
            return null;
        }
        if (!this.validExpression(expressionString)) {
            ErrorDialog errorDialog = new ErrorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), PARSER_ERROR_TITLE, null, (IStatus)new Status(4, "org.palladiosimulator.editors.sirius.services", PARSER_ERROR_MESSAGE), 4);
            errorDialog.open();
            return null;
        }
        ((PCMRandomVariable)pcmRandomVariable).setSpecification(expressionString);
        return pcmRandomVariable;
    }

    private boolean validExpression(String expressionString) {
        MyPCMStoExLexer lexer = new MyPCMStoExLexer((CharStream)new ANTLRStringStream(expressionString));
        MyPCMStoExParser parser = new MyPCMStoExParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        try {
            parser.expression();
        }
        catch (RecognitionException e1) {
            return false;
        }
        return !lexer.hasErrors() && !parser.hasErrors();
    }

    public DSemanticDiagram getSemanticDiagram(EObject containerView) {
        EObject container = containerView;
        while (!(container instanceof DSemanticDiagram)) {
            container = container.eContainer();
        }
        return (DSemanticDiagram)container;
    }
}

