/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.datastream.configurable;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;
import org.palladiosimulator.commons.emfutils.EMFLoadHelper;
import org.palladiosimulator.edp2.datastream.configurable.IPropertyConfigurable;
import org.palladiosimulator.edp2.datastream.configurable.PropertyConfigurable;

public abstract class PropertyConfigurableElementFactory
implements IElementFactory {
    private static final String CHILD_INPUTS_MEMENTO_TAG = String.valueOf(PropertyConfigurableElementFactory.class.getCanonicalName()) + "childInputs";

    public IAdaptable createElement(IMemento memento) {
        IPropertyConfigurable result = this.createElementInternal(memento);
        Map<String, Object> newProperties = this.getPropertiesFromMemento(memento, result);
        result.setProperties(newProperties);
        return result;
    }

    public static void saveConfigurationState(IMemento memento, IPropertyConfigurable configurable) {
        Map<String, Object> props = configurable.getProperties();
        for (String key : props.keySet()) {
            if (!configurable.isPropertyNotSet(key)) {
                memento.putString(key, PropertyConfigurableElementFactory.serialize(props.get(key)));
                continue;
            }
            memento.putString(key, null);
        }
    }

    private static String serialize(Object object) {
        if (ClassUtils.isAssignable(object.getClass(), Color.class, (boolean)true)) {
            Color col = (Color)object;
            return String.format("%08x", col.getRGB());
        }
        if (ClassUtils.isAssignable(object.getClass(), EObject.class, (boolean)true)) {
            return EMFLoadHelper.getResourceURI((EObject)((EObject)object));
        }
        return object.toString();
    }

    public static void persistChildren(IMemento memento, Collection children) {
        for (Object childObject : children) {
            IPersistableElement child = (IPersistableElement)childObject;
            IMemento subMemento = memento.createChild(CHILD_INPUTS_MEMENTO_TAG, child.getFactoryId());
            child.saveState(subMemento);
        }
    }

    public static List<IPersistableElement> loadChildren(IMemento memento) {
        IMemento[] inputMementos = memento.getChildren(CHILD_INPUTS_MEMENTO_TAG);
        ArrayList<IPersistableElement> result = new ArrayList<IPersistableElement>(inputMementos.length);
        IMemento[] iMementoArray = inputMementos;
        int n = inputMementos.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento subMemento = iMementoArray[n2];
            String id = subMemento.getID();
            IElementFactory inputFactory = PlatformUI.getWorkbench().getElementFactory(id);
            IPersistableElement createdInput = (IPersistableElement)inputFactory.createElement(subMemento);
            result.add(createdInput);
            ++n2;
        }
        return result;
    }

    private Map<String, Object> getPropertiesFromMemento(IMemento memento, IPropertyConfigurable configurable) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : configurable.getKeys()) {
            if (memento.getString(key) == null) {
                result.put(key, PropertyConfigurable.NOT_SET);
                continue;
            }
            result.put(key, this.deserialize(memento.getString(key), configurable.getPropertyType(key)));
        }
        return Collections.unmodifiableMap(result);
    }

    private Object deserialize(String string, Class<?> propertyType) {
        if (ClassUtils.isAssignable(propertyType, String.class, (boolean)true)) {
            return string;
        }
        if (ClassUtils.isAssignable(propertyType, Boolean.class, (boolean)true)) {
            return "true".equals(string);
        }
        if (ClassUtils.isAssignable(propertyType, Integer.class, (boolean)true)) {
            return Integer.parseInt(string);
        }
        if (ClassUtils.isAssignable(propertyType, Float.class, (boolean)true)) {
            return Float.valueOf(Float.parseFloat(string));
        }
        if (ClassUtils.isAssignable(propertyType, Double.class, (boolean)true)) {
            return Double.parseDouble(string);
        }
        if (ClassUtils.isAssignable(propertyType, Color.class, (boolean)true)) {
            Color col = Color.decode(string.substring(2));
            return new Color(col.getRed(), col.getBlue(), col.getBlue(), Integer.parseInt(string.substring(0, 1), 16));
        }
        if (ClassUtils.isAssignable(propertyType, EObject.class, (boolean)true)) {
            return EMFLoadHelper.loadAndResolveEObject((String)string);
        }
        throw new UnsupportedOperationException("Deserialize of unsupported type found: " + propertyType);
    }

    protected abstract IPropertyConfigurable createElementInternal(IMemento var1);
}

