/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentanalysis;

import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import javax.measure.Measurable;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.eclipse.emf.ecore.EClass;
import org.palladiosimulator.commons.designpatterns.AbstractObservable;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.experimentanalysis.ISlidingWindowListener;
import org.palladiosimulator.experimentanalysis.ISlidingWindowMoveOnStrategy;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSpecPackage;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;

public abstract class SlidingWindow
extends AbstractObservable<ISlidingWindowListener> {
    private static final NumericalBaseMetricDescription POINT_IN_TIME_METRIC = (NumericalBaseMetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC;
    private static final EClass BASE_METRIC_DESC_ECLASS = MetricSpecPackage.Literals.BASE_METRIC_DESCRIPTION;
    private final Measure<Double, Duration> windowLength;
    private Measure<Double, Duration> currentLowerBound;
    private final Measure<Double, Duration> increment;
    private final MetricDescription acceptedMetrics;
    private final ISlidingWindowMoveOnStrategy moveOnStrategy;
    private final Deque<MeasuringValue> data = new LinkedList<MeasuringValue>();
    private final boolean acceptsBaseMetric;

    public SlidingWindow(Measure<Double, Duration> windowLength, MetricDescription acceptedMetrics, ISlidingWindowMoveOnStrategy moveOnStrategy) {
        this(windowLength, windowLength, acceptedMetrics, moveOnStrategy);
    }

    public SlidingWindow(Measure<Double, Duration> windowLength, Measure<Double, Duration> increment, MetricDescription acceptedMetrics, ISlidingWindowMoveOnStrategy moveOnStrategy) {
        this(windowLength, increment, (Measure<Double, Duration>)Measure.valueOf((double)0.0, (Unit)SI.SECOND), acceptedMetrics, moveOnStrategy);
    }

    public SlidingWindow(Measure<Double, Duration> windowLength, Measure<Double, Duration> increment, Measure<Double, Duration> initialLowerBound, MetricDescription acceptedMetrics, ISlidingWindowMoveOnStrategy moveOnStrategy) {
        SlidingWindow.checkCtorParameters(windowLength, increment, initialLowerBound, acceptedMetrics, moveOnStrategy);
        this.windowLength = Measure.valueOf((double)windowLength.doubleValue(windowLength.getUnit()), (Unit)windowLength.getUnit());
        this.increment = Measure.valueOf((double)increment.doubleValue(increment.getUnit()), (Unit)increment.getUnit());
        this.currentLowerBound = initialLowerBound;
        this.acceptedMetrics = acceptedMetrics;
        this.moveOnStrategy = moveOnStrategy;
        this.acceptsBaseMetric = BASE_METRIC_DESC_ECLASS.isInstance((Object)this.acceptedMetrics);
    }

    private static void checkCtorParameters(Measure<Double, Duration> windowLength, Measure<Double, Duration> increment, Measure<Double, Duration> initialLowerBound, MetricDescription acceptedMetrics, ISlidingWindowMoveOnStrategy moveOnStrategy) {
        if (!SlidingWindow.isDurationMeasureValid(windowLength, false)) {
            throw new IllegalArgumentException("Given window length is invalid.");
        }
        if (!SlidingWindow.isDurationMeasureValid(increment, false)) {
            throw new IllegalArgumentException("Given increment is invalid.");
        }
        if (!SlidingWindow.isDurationMeasureValid(initialLowerBound, true)) {
            throw new IllegalArgumentException("Given inital lower bound is invalid.");
        }
        if (acceptedMetrics == null) {
            throw new IllegalArgumentException("A sliding window only accepts measurements that adhere to a metric'.\nSuch a metric description was not given.");
        }
        if (moveOnStrategy == null) {
            throw new IllegalArgumentException("An moveOnStrategy must be given that defines what happens to the (potentially obsolete)window data when the window is incremented.");
        }
    }

    private static boolean isDurationMeasureValid(Measure<Double, Duration> measure, boolean greaterEqualsZero) {
        boolean result = false;
        if (measure != null) {
            Double value = measure.doubleValue(measure.getUnit());
            result = value != null && !value.isInfinite() && !value.isNaN() && (greaterEqualsZero ? value >= 0.0 : value > 0.0);
        }
        return result;
    }

    protected final void onWindowFullEvent() {
        this.notifyObserversOnWindowFull();
        this.moveOn();
    }

    private void notifyObserversOnWindowFull() {
        ((ISlidingWindowListener)this.getEventDispatcher()).onSlidingWindowFull(Collections.unmodifiableCollection(this.data), this.currentLowerBound, this.getEffectiveWindowLength());
    }

    private boolean measurementAdheresToMetric(MeasuringValue measurement) {
        return measurement.isCompatibleWith(this.acceptedMetrics) || this.acceptsBaseMetric() && MetricDescriptionUtility.isBaseMetricDescriptionSubsumedByMetricDescription((BaseMetricDescription)((BaseMetricDescription)this.acceptedMetrics), (MetricDescription)measurement.getMetricDesciption());
    }

    public void addMeasurement(MeasuringValue newMeasurement) {
        this.checkAddMeasurementPrerequisites(newMeasurement);
        this.addMeasurementInternal(newMeasurement);
    }

    protected void checkAddMeasurementPrerequisites(MeasuringValue newMeasurement) {
        if (newMeasurement == null) {
            throw new IllegalArgumentException("Given measurement is null.");
        }
        if (!this.measurementAdheresToMetric(newMeasurement)) {
            throw new IllegalArgumentException("Given measurement does not adhere to (or subsume) specified metric.\nExpected metric: " + this.acceptedMetrics.getName() + "\nGiven measurement metric: " + newMeasurement.getMetricDesciption().getName());
        }
    }

    protected final void addMeasurementInternal(MeasuringValue newMeasurement) {
        Measure pointInTime = newMeasurement.getMeasureForMetric((MetricDescription)POINT_IN_TIME_METRIC);
        if (this.getCurrentLowerBound().compareTo((Measurable)pointInTime) > 0) {
            this.flush();
        }
        this.data.addLast(newMeasurement);
    }

    public final void flush() {
        this.data.clear();
    }

    public final MetricDescription getAcceptedMetric() {
        return this.acceptedMetrics;
    }

    protected final boolean acceptsBaseMetric() {
        return this.acceptsBaseMetric;
    }

    public final Measure<Double, Duration> getCurrentLowerBound() {
        return this.currentLowerBound;
    }

    public Measure<Double, Duration> getCurrentUpperBound() {
        double lowerBoundValue = (Double)this.currentLowerBound.getValue();
        double upperBoundValue = lowerBoundValue + this.getSpecifiedWindowLength().doubleValue(this.currentLowerBound.getUnit());
        return Measure.valueOf((double)upperBoundValue, (Unit)this.currentLowerBound.getUnit());
    }

    protected final Measure<Double, Duration> getSpecifiedWindowLength() {
        return this.windowLength;
    }

    public Measure<Double, Duration> getEffectiveWindowLength() {
        return this.getSpecifiedWindowLength();
    }

    public final Measure<Double, Duration> getIncrement() {
        return this.increment;
    }

    private void moveOn() {
        this.adjustLowerBound();
        this.moveOnStrategy.adjustData(this.data, this.currentLowerBound, this.increment);
    }

    private void adjustLowerBound() {
        this.currentLowerBound = Measure.valueOf((double)((Double)this.currentLowerBound.getValue() + this.increment.doubleValue(this.currentLowerBound.getUnit())), (Unit)this.currentLowerBound.getUnit());
    }

    public final boolean isEmpty() {
        return this.data.isEmpty();
    }

    public final int getNumberOfElements() {
        return this.data.size();
    }

    public final void addObserver(ISlidingWindowListener arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Observer to attach must not be null.");
        }
        if (!this.acceptedMetrics.equals(arg0.getExpectedWindowDataMetric())) {
            throw new IllegalArgumentException("Listener cannot be attached as it is expecting a metric other than this window's accepted one.");
        }
        super.addObserver((Object)arg0);
    }

    public final List<ISlidingWindowListener> getAttachedObservers() {
        return Collections.unmodifiableList(super.getObservers());
    }
}

