/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentanalysis;

import java.util.Arrays;
import org.palladiosimulator.experimentanalysis.ISlidingWindowListener;
import org.palladiosimulator.experimentanalysis.SlidingWindow;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.recorderframework.AbstractRecorder;
import org.palladiosimulator.recorderframework.config.IRecorderConfiguration;

public class SlidingWindowRecorder
extends AbstractRecorder {
    private final SlidingWindow slidingWindow;

    public SlidingWindowRecorder(SlidingWindow slidingWindow, Iterable<ISlidingWindowListener> listeners) {
        if (slidingWindow == null) {
            throw new IllegalArgumentException("A sliding window always corresponds with a sliding window\nThus, the passed window reference must not be null.");
        }
        this.slidingWindow = slidingWindow;
        if (listeners != null) {
            for (ISlidingWindowListener iSlidingWindowListener : listeners) {
                this.slidingWindow.addObserver(iSlidingWindowListener);
            }
        }
    }

    public SlidingWindowRecorder(SlidingWindow slidingWindow, ISlidingWindowListener listener) {
        this(slidingWindow, Arrays.asList(listener));
    }

    public void initialize(IRecorderConfiguration recorderConfiguration) {
    }

    public void writeData(MeasuringValue measurement) {
        this.slidingWindow.addMeasurement(measurement);
    }

    public void flush() {
        this.slidingWindow.flush();
    }
}

