/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentanalysis.windowaggregators;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Objects;
import javax.measure.Measurable;
import javax.measure.Measure;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.experimentanalysis.windowaggregators.SlidingWindowUtilizationAggregator;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.recorderframework.IRecorder;

public final class SlidingWindowExponentialSmoothingUtilizationAggregator
extends SlidingWindowUtilizationAggregator {
    private static final Amount<Dimensionless> ZERO_LOAD = Amount.ZERO;
    private Amount<Dimensionless> currentLoadAverage = ZERO_LOAD;
    private final double smoothingFactor;
    private final double oneMinusSmoothingFactor;
    private final Amount<Duration> samplingRate;

    public SlidingWindowExponentialSmoothingUtilizationAggregator(MetricDescription windowDataMetric, IRecorder recorderToWriteInto, Measurable<Duration> samplingRate, Measurable<Duration> reportingPeriod) {
        super(windowDataMetric, recorderToWriteInto);
        SlidingWindowExponentialSmoothingUtilizationAggregator.checkDurationMeasurables(samplingRate, reportingPeriod);
        this.samplingRate = Amount.valueOf((double)samplingRate.doubleValue((Unit)SI.SECOND), (Unit)SI.SECOND);
        this.smoothingFactor = SlidingWindowExponentialSmoothingUtilizationAggregator.computeSmoothingFactor(samplingRate.doubleValue((Unit)SI.SECOND), reportingPeriod.doubleValue((Unit)SI.SECOND));
        this.oneMinusSmoothingFactor = 1.0 - this.smoothingFactor;
    }

    private static void checkDurationMeasurables(Measurable<Duration> samplingRate, Measurable<Duration> reportingPeriod) {
        if (ZERO_DURATION.compareTo(Objects.requireNonNull(samplingRate)) >= 0) {
            throw new IllegalArgumentException("Passed sampling rate must be positive!");
        }
        if (ZERO_DURATION.compareTo(Objects.requireNonNull(reportingPeriod)) >= 0) {
            throw new IllegalArgumentException("Passed reporting period must be positive!");
        }
    }

    private static double computeSmoothingFactor(double samplingRate, double reportingPeriod) {
        return -Math.expm1(-samplingRate / reportingPeriod);
    }

    private void updateLoadAverage(Amount<Dimensionless> stateAmount) {
        this.currentLoadAverage = this.currentLoadAverage.times(this.oneMinusSmoothingFactor).plus(stateAmount.times(this.smoothingFactor));
    }

    @Override
    protected MeasuringValue processWindowData(Iterable<MeasuringValue> windowData, Measure<Double, Duration> windowLeftBound, Measure<Double, Duration> windowLength) {
        Amount windowLeftBoundAmount;
        Unit usedDurationUnit = windowLeftBound.getUnit();
        Amount currentSamplingPoint = windowLeftBoundAmount = Amount.valueOf((double)((Double)windowLeftBound.getValue()), (Unit)usedDurationUnit);
        PeekingIterator iterator = Iterators.peekingIterator(windowData.iterator());
        while (iterator.hasNext()) {
            MeasuringValue current = (MeasuringValue)iterator.next();
            Amount<Duration> currentPointInTime = SlidingWindowExponentialSmoothingUtilizationAggregator.obtainPointInTimeAmountFromMeasurement(current);
            Amount<Dimensionless> currentState = this.obtainStateAmountFromMeasurement(current);
            while (currentPointInTime.isGreaterThan(currentSamplingPoint)) {
                currentSamplingPoint = currentSamplingPoint.plus(this.samplingRate);
            }
            if (iterator.hasNext()) {
                Amount<Duration> peekedNextPointInTime = SlidingWindowExponentialSmoothingUtilizationAggregator.obtainPointInTimeAmountFromMeasurement((MeasuringValue)iterator.peek());
                while (peekedNextPointInTime.isGreaterThan(currentSamplingPoint)) {
                    assert (!currentPointInTime.isGreaterThan(currentSamplingPoint));
                    this.updateLoadAverage(currentState);
                    currentSamplingPoint = currentSamplingPoint.plus(this.samplingRate);
                }
                continue;
            }
            if (currentPointInTime.isGreaterThan(currentSamplingPoint)) continue;
            this.updateLoadAverage(currentState);
        }
        return new TupleMeasurement(MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE_TUPLE, new Measure[]{Measure.valueOf((double)((Double)windowLeftBound.getValue() + windowLength.doubleValue(usedDurationUnit)), (Unit)usedDurationUnit), Measure.valueOf((double)this.currentLoadAverage.doubleValue(Unit.ONE), (Unit)Unit.ONE)});
    }

    public Measurable<Duration> getSamplingRate() {
        return this.samplingRate;
    }

    public double getSmoothingFactor() {
        return this.smoothingFactor;
    }
}

