/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentautomation.application.tooladapter.simulizar;

import de.uka.ipd.sdq.codegen.simucontroller.runconfig.AbstractSimulationWorkflowConfiguration;
import de.uka.ipd.sdq.simucomframework.SimuComConfig;
import de.uka.ipd.sdq.simulation.AbstractSimulationConfig;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.palladiosimulator.experimentautomation.abstractsimulation.AbstractSimulationConfiguration;
import org.palladiosimulator.experimentautomation.application.VariationFactorTuple;
import org.palladiosimulator.experimentautomation.application.jobs.CheckForSLOViolationsJob;
import org.palladiosimulator.experimentautomation.application.jobs.LogExperimentInformationJob;
import org.palladiosimulator.experimentautomation.application.tooladapter.IToolAdapter;
import org.palladiosimulator.experimentautomation.application.tooladapter.RunAnalysisJob;
import org.palladiosimulator.experimentautomation.application.tooladapter.abstractsimulation.AbstractSimulationConfigFactory;
import org.palladiosimulator.experimentautomation.application.tooladapter.abstractsimulation.AbstractSimulationWorkflowConfigurationFactory;
import org.palladiosimulator.experimentautomation.application.tooladapter.simulizar.model.SimuLizarConfiguration;
import org.palladiosimulator.experimentautomation.application.tooladapter.simulizar.model.SimulizartooladapterPackage;
import org.palladiosimulator.experimentautomation.experiments.Experiment;
import org.palladiosimulator.experimentautomation.experiments.ReconfigurationRulesFolder;
import org.palladiosimulator.experimentautomation.experiments.ToolConfiguration;
import org.palladiosimulator.simulizar.launcher.jobs.PCMStartInterpretationJob;
import org.palladiosimulator.simulizar.runconfig.SimuLizarWorkflowConfiguration;

public class SimuLizarToolAdapter
implements IToolAdapter {
    private static final String SIMULATOR_ID_SIMULIZAR = "de.uka.ipd.sdq.codegen.simucontroller.simucom";

    public RunAnalysisJob createRunAnalysisJob(Experiment experiment, ToolConfiguration toolConfig, List<VariationFactorTuple> variationFactorTuples, int repetition) {
        SimuLizarConfiguration simuLizarToolConfig = (SimuLizarConfiguration)toolConfig;
        Map configMap = AbstractSimulationConfigFactory.createConfigMap((Experiment)experiment, (AbstractSimulationConfiguration)simuLizarToolConfig, (String)SIMULATOR_ID_SIMULIZAR, variationFactorTuples);
        SimuComConfig simuComConfig = this.createSimuComConfig(configMap);
        SimuLizarWorkflowConfiguration workflowConfig = this.createSimuLizarWorkflowConfiguration(simuComConfig, experiment.getInitialModel().getReconfigurationRules());
        RunAnalysisJob result = new RunAnalysisJob();
        result.setConfiguration(configMap);
        result.addJob((IJob)new LogExperimentInformationJob(experiment, (AbstractSimulationConfig)simuComConfig, variationFactorTuples, repetition));
        result.addJob((IJob)new PCMStartInterpretationJob(workflowConfig));
        if (experiment.getInitialModel().getServiceLevelObjectives() != null) {
            result.addJob((IJob)new CheckForSLOViolationsJob(result, experiment.getInitialModel().getServiceLevelObjectives(), simuLizarToolConfig.getDatasource(), simuComConfig.getNameBase(), simuComConfig.getVariationId()));
        }
        return result;
    }

    public boolean hasSupportFor(ToolConfiguration configuration) {
        return SimulizartooladapterPackage.eINSTANCE.getSimuLizarConfiguration().isInstance((Object)configuration);
    }

    private SimuComConfig createSimuComConfig(Map<String, Object> configMap) {
        configMap.put("simulateLinkingResources", false);
        configMap.put("simulateFailures", false);
        return new SimuComConfig(configMap, false);
    }

    private SimuLizarWorkflowConfiguration createSimuLizarWorkflowConfiguration(SimuComConfig simuComConfig, ReconfigurationRulesFolder reconfigurationRulesFolder) {
        SimuLizarWorkflowConfiguration workflowConfig = new SimuLizarWorkflowConfiguration(new HashMap());
        AbstractSimulationWorkflowConfigurationFactory.fillWorkflowConfiguration((AbstractSimulationWorkflowConfiguration)workflowConfig);
        workflowConfig.setSimuComConfiguration(simuComConfig);
        if (reconfigurationRulesFolder == null) {
            workflowConfig.setReconfigurationRulesFolder("");
        } else {
            workflowConfig.setReconfigurationRulesFolder(reconfigurationRulesFolder.getFolderUri());
        }
        return workflowConfig;
    }
}

