/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentautomation.application.tooladapter.abstractsimulation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.experimentautomation.abstractsimulation.AbstractSimulationConfiguration;
import org.palladiosimulator.experimentautomation.abstractsimulation.AbstractsimulationPackage;
import org.palladiosimulator.experimentautomation.abstractsimulation.EDP2Datasource;
import org.palladiosimulator.experimentautomation.abstractsimulation.MeasurementCountStopCondition;
import org.palladiosimulator.experimentautomation.abstractsimulation.RandomNumberGeneratorSeed;
import org.palladiosimulator.experimentautomation.abstractsimulation.SimTimeStopCondition;
import org.palladiosimulator.experimentautomation.abstractsimulation.StopCondition;
import org.palladiosimulator.experimentautomation.application.VariationFactorTuple;
import org.palladiosimulator.experimentautomation.application.tooladapter.abstractsimulation.EDP2DatasourceFactory;
import org.palladiosimulator.experimentautomation.experiments.Experiment;

public class AbstractSimulationConfigFactory {
    public static Map<String, Object> createConfigMap(Experiment experiment, AbstractSimulationConfiguration simConfig, String simulatorID, List<VariationFactorTuple> variationFactorTuples) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("simulatorId", simulatorID);
        map.put("experimentRun", AbstractSimulationConfigFactory.computeExperimentGroupPurpose(experiment));
        map.put("variationId", AbstractSimulationConfigFactory.computeExperimentSettingName(simConfig, variationFactorTuples));
        map.put("persistenceFramework", "Experiment Data Persistency & Presentation (EDP2)");
        map.put("EDP2RepositoryID", AbstractSimulationConfigFactory.getPersistenceRecorder(simConfig.getDatasource()));
        map.put("simTime", AbstractSimulationConfigFactory.getMaximumSimulationTime(experiment, simConfig));
        map.put("maximumMeasurementCount", AbstractSimulationConfigFactory.getMaximumMeasurementCount(experiment, simConfig));
        map.put("verboseLogging", false);
        if (simConfig.getRandomNumberGeneratorSeed() != null) {
            map.put("useFixedSeed", true);
            RandomNumberGeneratorSeed seed = simConfig.getRandomNumberGeneratorSeed();
            map.put("fixedSeed0", seed.getSeed0());
            map.put("fixedSeed1", seed.getSeed1());
            map.put("fixedSeed2", seed.getSeed2());
            map.put("fixedSeed3", seed.getSeed3());
            map.put("fixedSeed4", seed.getSeed4());
            map.put("fixedSeed5", seed.getSeed5());
        } else {
            map.put("useFixedSeed", false);
        }
        AbstractSimulationConfigFactory.adjustMapValueTypes(map);
        return map;
    }

    public static String computeExperimentGroupPurpose(Experiment experiment) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(experiment.getName());
        stringBuilder.append(" [");
        stringBuilder.append(experiment.getId());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static String computeExperimentSettingName(AbstractSimulationConfiguration simConfig, List<VariationFactorTuple> variationFactorTuples) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Variation ");
        stringBuilder.append(variationFactorTuples.toString());
        stringBuilder.append(" [");
        stringBuilder.append(simConfig.getName());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static int getMaximumSimulationTime(Experiment experiment, AbstractSimulationConfiguration simConfig) {
        int result = AbstractSimulationConfigFactory.getMaximumSimulationTime((EList<StopCondition>)experiment.getStopConditions());
        if (result == -1) {
            result = AbstractSimulationConfigFactory.getMaximumSimulationTime((EList<StopCondition>)simConfig.getStopConditions());
        }
        return result;
    }

    private static int getMaximumSimulationTime(EList<StopCondition> stopConditions) {
        for (StopCondition s : stopConditions) {
            if (!AbstractsimulationPackage.eINSTANCE.getSimTimeStopCondition().isInstance((Object)s)) continue;
            return ((SimTimeStopCondition)s).getSimulationTime();
        }
        return -1;
    }

    private static int getMaximumMeasurementCount(Experiment experiment, AbstractSimulationConfiguration simConfig) {
        int result = AbstractSimulationConfigFactory.getMaximumMeasurementCount((EList<StopCondition>)experiment.getStopConditions());
        if (result == -1) {
            result = AbstractSimulationConfigFactory.getMaximumMeasurementCount((EList<StopCondition>)simConfig.getStopConditions());
        }
        return result;
    }

    private static int getMaximumMeasurementCount(EList<StopCondition> stopConditions) {
        for (StopCondition s : stopConditions) {
            if (!AbstractsimulationPackage.eINSTANCE.getMeasurementCountStopCondition().isInstance((Object)s)) continue;
            return ((MeasurementCountStopCondition)s).getMeasurementCount();
        }
        return -1;
    }

    private static String getPersistenceRecorder(EDP2Datasource datasource) {
        Repository repository = EDP2DatasourceFactory.createOrOpenDatasource(datasource);
        return repository.getId();
    }

    private static void adjustMapValueTypes(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Boolean) continue;
            entry.setValue(value.toString());
        }
    }
}

