/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementframework;

import java.util.ArrayList;
import java.util.List;
import javax.measure.Measure;
import javax.measure.quantity.Quantity;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.Identifier;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;

public final class BasicMeasurement<VALUE_TYPE, QUANTITY extends Quantity>
extends MeasuringValue {
    private final Measure<VALUE_TYPE, QUANTITY> measure;

    public BasicMeasurement(Measure<VALUE_TYPE, QUANTITY> measure, BaseMetricDescription metricDescription) {
        super((MetricDescription)metricDescription);
        this.checkMeasureDataType(measure, metricDescription);
        this.measure = measure;
    }

    private void checkMeasureDataType(Measure<VALUE_TYPE, QUANTITY> measure, BaseMetricDescription metricDescription) {
        Class valueDataType;
        switch (metricDescription.getCaptureType()) {
            case IDENTIFIER: {
                valueDataType = Identifier.class;
                break;
            }
            case INTEGER_NUMBER: {
                valueDataType = Long.class;
                break;
            }
            case REAL_NUMBER: {
                valueDataType = Double.class;
                break;
            }
            default: {
                valueDataType = null;
            }
        }
        if (!valueDataType.isAssignableFrom(measure.getValue().getClass())) {
            throw new IllegalArgumentException("Datatype of measurement (" + measure.getValue().getClass().getName() + ") not compatible with declared base metric (" + valueDataType.getName() + "; " + metricDescription.getName() + ")");
        }
        if (metricDescription instanceof NumericalBaseMetricDescription) {
            NumericalBaseMetricDescription numericalBaseMetricDescription = (NumericalBaseMetricDescription)metricDescription;
            if (!measure.getUnit().isCompatible(numericalBaseMetricDescription.getDefaultUnit())) {
                throw new IllegalArgumentException("Unit of measurement (" + measure.getUnit() + ") not compatible with declared base metric unit (" + numericalBaseMetricDescription.getDefaultUnit() + ") of metric description \"" + numericalBaseMetricDescription.getName() + "\"");
            }
        }
    }

    public final Measure<VALUE_TYPE, QUANTITY> getMeasure() {
        return this.measure;
    }

    @Override
    public List<Measure<?, ?>> asList() {
        ArrayList result = new ArrayList(1);
        result.add(this.measure);
        return result;
    }

    public <S, T extends Quantity> Measure<S, T> getMeasureForMetric(MetricDescription wantedMetric) {
        if (wantedMetric == null || !(wantedMetric instanceof BaseMetricDescription)) {
            throw new IllegalArgumentException("Only base metrics have measures attached.");
        }
        MeasuringValue wantedMeasurement = this.getMeasuringValueForMetric(wantedMetric);
        if (wantedMeasurement == null || !(wantedMeasurement instanceof BasicMeasurement)) {
            throw new IllegalStateException("Measurement for a base metric is not an BasicMeasurement.");
        }
        BasicMeasurement basicMeasurement = (BasicMeasurement)wantedMeasurement;
        return basicMeasurement.getMeasure();
    }
}

