/**
 * Copyright 2005-2009 by SDQ, IPD, University of Karlsruhe, Germany
 */
package org.palladiosimulator.pcm.core.composition.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ChildCreationExtenderManager;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.palladiosimulator.pcm.core.composition.CompositionPackage;
import org.palladiosimulator.pcm.core.composition.util.CompositionAdapterFactory;
import org.palladiosimulator.pcm.core.provider.PalladioComponentModelEditPlugin;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers. The
 * adapters generated by this factory convert EMF adapter notifications into calls to
 * {@link #fireNotifyChanged fireNotifyChanged}. The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances. <!-- begin-user-doc --> <!--
 * end-user-doc -->
 * 
 * @generated
 */
public class CompositionItemProviderAdapterFactory extends CompositionAdapterFactory
        implements ComposeableAdapterFactory, IChangeNotifier, IDisposable, IChildCreationExtender {

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public static final String copyright = "Copyright 2005-2017 by palladiosimulator.org";

    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This helps manage the child creation extenders. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager(
            PalladioComponentModelEditPlugin.INSTANCE, CompositionPackage.eNS_URI);

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType
     * isFactoryForType}. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object>();

    /**
     * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public CompositionItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.core.composition.ResourceRequiredDelegationConnector}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected ResourceRequiredDelegationConnectorItemProvider resourceRequiredDelegationConnectorItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.pcm.core.composition.ResourceRequiredDelegationConnector}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createResourceRequiredDelegationConnectorAdapter() {
        if (this.resourceRequiredDelegationConnectorItemProvider == null) {
            this.resourceRequiredDelegationConnectorItemProvider = new ResourceRequiredDelegationConnectorItemProvider(
                    this);
        }

        return this.resourceRequiredDelegationConnectorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.core.composition.EventChannel} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected EventChannelItemProvider eventChannelItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.pcm.core.composition.EventChannel}. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createEventChannelAdapter() {
        if (this.eventChannelItemProvider == null) {
            this.eventChannelItemProvider = new EventChannelItemProvider(this);
        }

        return this.eventChannelItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.core.composition.EventChannelSourceConnector} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected EventChannelSourceConnectorItemProvider eventChannelSourceConnectorItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.pcm.core.composition.EventChannelSourceConnector}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createEventChannelSourceConnectorAdapter() {
        if (this.eventChannelSourceConnectorItemProvider == null) {
            this.eventChannelSourceConnectorItemProvider = new EventChannelSourceConnectorItemProvider(this);
        }

        return this.eventChannelSourceConnectorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.core.composition.EventChannelSinkConnector} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected EventChannelSinkConnectorItemProvider eventChannelSinkConnectorItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.pcm.core.composition.EventChannelSinkConnector}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createEventChannelSinkConnectorAdapter() {
        if (this.eventChannelSinkConnectorItemProvider == null) {
            this.eventChannelSinkConnectorItemProvider = new EventChannelSinkConnectorItemProvider(this);
        }

        return this.eventChannelSinkConnectorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected ProvidedDelegationConnectorItemProvider providedDelegationConnectorItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createProvidedDelegationConnectorAdapter() {
        if (this.providedDelegationConnectorItemProvider == null) {
            this.providedDelegationConnectorItemProvider = new ProvidedDelegationConnectorItemProvider(this);
        }

        return this.providedDelegationConnectorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.core.composition.RequiredDelegationConnector} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected RequiredDelegationConnectorItemProvider requiredDelegationConnectorItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.pcm.core.composition.RequiredDelegationConnector}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createRequiredDelegationConnectorAdapter() {
        if (this.requiredDelegationConnectorItemProvider == null) {
            this.requiredDelegationConnectorItemProvider = new RequiredDelegationConnectorItemProvider(this);
        }

        return this.requiredDelegationConnectorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.core.composition.AssemblyConnector} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected AssemblyConnectorItemProvider assemblyConnectorItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.pcm.core.composition.AssemblyConnector}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createAssemblyConnectorAdapter() {
        if (this.assemblyConnectorItemProvider == null) {
            this.assemblyConnectorItemProvider = new AssemblyConnectorItemProvider(this);
        }

        return this.assemblyConnectorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.core.composition.AssemblyEventConnector} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected AssemblyEventConnectorItemProvider assemblyEventConnectorItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.pcm.core.composition.AssemblyEventConnector}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createAssemblyEventConnectorAdapter() {
        if (this.assemblyEventConnectorItemProvider == null) {
            this.assemblyEventConnectorItemProvider = new AssemblyEventConnectorItemProvider(this);
        }

        return this.assemblyEventConnectorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.core.composition.SourceDelegationConnector} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected SourceDelegationConnectorItemProvider sourceDelegationConnectorItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.pcm.core.composition.SourceDelegationConnector}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createSourceDelegationConnectorAdapter() {
        if (this.sourceDelegationConnectorItemProvider == null) {
            this.sourceDelegationConnectorItemProvider = new SourceDelegationConnectorItemProvider(this);
        }

        return this.sourceDelegationConnectorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.core.composition.SinkDelegationConnector} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected SinkDelegationConnectorItemProvider sinkDelegationConnectorItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.pcm.core.composition.SinkDelegationConnector}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createSinkDelegationConnectorAdapter() {
        if (this.sinkDelegationConnectorItemProvider == null) {
            this.sinkDelegationConnectorItemProvider = new SinkDelegationConnectorItemProvider(this);
        }

        return this.sinkDelegationConnectorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.core.composition.AssemblyInfrastructureConnector} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected AssemblyInfrastructureConnectorItemProvider assemblyInfrastructureConnectorItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.pcm.core.composition.AssemblyInfrastructureConnector}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createAssemblyInfrastructureConnectorAdapter() {
        if (this.assemblyInfrastructureConnectorItemProvider == null) {
            this.assemblyInfrastructureConnectorItemProvider = new AssemblyInfrastructureConnectorItemProvider(this);
        }

        return this.assemblyInfrastructureConnectorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.core.composition.ProvidedInfrastructureDelegationConnector}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected ProvidedInfrastructureDelegationConnectorItemProvider providedInfrastructureDelegationConnectorItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.pcm.core.composition.ProvidedInfrastructureDelegationConnector}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createProvidedInfrastructureDelegationConnectorAdapter() {
        if (this.providedInfrastructureDelegationConnectorItemProvider == null) {
            this.providedInfrastructureDelegationConnectorItemProvider = new ProvidedInfrastructureDelegationConnectorItemProvider(
                    this);
        }

        return this.providedInfrastructureDelegationConnectorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.core.composition.RequiredInfrastructureDelegationConnector}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected RequiredInfrastructureDelegationConnectorItemProvider requiredInfrastructureDelegationConnectorItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.pcm.core.composition.RequiredInfrastructureDelegationConnector}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createRequiredInfrastructureDelegationConnectorAdapter() {
        if (this.requiredInfrastructureDelegationConnectorItemProvider == null) {
            this.requiredInfrastructureDelegationConnectorItemProvider = new RequiredInfrastructureDelegationConnectorItemProvider(
                    this);
        }

        return this.requiredInfrastructureDelegationConnectorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.core.composition.RequiredResourceDelegationConnector}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected RequiredResourceDelegationConnectorItemProvider requiredResourceDelegationConnectorItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.pcm.core.composition.RequiredResourceDelegationConnector}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createRequiredResourceDelegationConnectorAdapter() {
        if (this.requiredResourceDelegationConnectorItemProvider == null) {
            this.requiredResourceDelegationConnectorItemProvider = new RequiredResourceDelegationConnectorItemProvider(
                    this);
        }

        return this.requiredResourceDelegationConnectorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.core.composition.AssemblyContext} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected AssemblyContextItemProvider assemblyContextItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.pcm.core.composition.AssemblyContext}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createAssemblyContextAdapter() {
        if (this.assemblyContextItemProvider == null) {
            this.assemblyContextItemProvider = new AssemblyContextItemProvider(this);
        }

        return this.assemblyContextItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void setParentAdapterFactory(final ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public boolean isFactoryForType(final Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter adapt(final Notifier notifier, final Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Object adapt(final Object object, final Object type) {
        if (this.isFactoryForType(type)) {
            final Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public List<IChildCreationExtender> getChildCreationExtenders() {
        return this.childCreationExtenderManager.getChildCreationExtenders();
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Collection<?> getNewChildDescriptors(final Object object, final EditingDomain editingDomain) {
        return this.childCreationExtenderManager.getNewChildDescriptors(object, editingDomain);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public ResourceLocator getResourceLocator() {
        return this.childCreationExtenderManager;
    }

    /**
     * This adds a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void addListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void removeListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void fireNotifyChanged(final Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);

        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    /**
     * This disposes all of the item providers created by this factory. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void dispose() {
        if (this.resourceRequiredDelegationConnectorItemProvider != null) {
            this.resourceRequiredDelegationConnectorItemProvider.dispose();
        }
        if (this.eventChannelItemProvider != null) {
            this.eventChannelItemProvider.dispose();
        }
        if (this.eventChannelSourceConnectorItemProvider != null) {
            this.eventChannelSourceConnectorItemProvider.dispose();
        }
        if (this.eventChannelSinkConnectorItemProvider != null) {
            this.eventChannelSinkConnectorItemProvider.dispose();
        }
        if (this.providedDelegationConnectorItemProvider != null) {
            this.providedDelegationConnectorItemProvider.dispose();
        }
        if (this.requiredDelegationConnectorItemProvider != null) {
            this.requiredDelegationConnectorItemProvider.dispose();
        }
        if (this.assemblyConnectorItemProvider != null) {
            this.assemblyConnectorItemProvider.dispose();
        }
        if (this.assemblyEventConnectorItemProvider != null) {
            this.assemblyEventConnectorItemProvider.dispose();
        }
        if (this.sourceDelegationConnectorItemProvider != null) {
            this.sourceDelegationConnectorItemProvider.dispose();
        }
        if (this.sinkDelegationConnectorItemProvider != null) {
            this.sinkDelegationConnectorItemProvider.dispose();
        }
        if (this.assemblyInfrastructureConnectorItemProvider != null) {
            this.assemblyInfrastructureConnectorItemProvider.dispose();
        }
        if (this.providedInfrastructureDelegationConnectorItemProvider != null) {
            this.providedInfrastructureDelegationConnectorItemProvider.dispose();
        }
        if (this.requiredInfrastructureDelegationConnectorItemProvider != null) {
            this.requiredInfrastructureDelegationConnectorItemProvider.dispose();
        }
        if (this.requiredResourceDelegationConnectorItemProvider != null) {
            this.requiredResourceDelegationConnectorItemProvider.dispose();
        }
        if (this.assemblyContextItemProvider != null) {
            this.assemblyContextItemProvider.dispose();
        }
    }

}
