/**
 * Copyright 2005-2009 by SDQ, IPD, University of Karlsruhe, Germany
 */
package org.palladiosimulator.pcm.seff.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ChildCreationExtenderManager;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.palladiosimulator.pcm.core.provider.PalladioComponentModelEditPlugin;
import org.palladiosimulator.pcm.seff.SeffPackage;
import org.palladiosimulator.pcm.seff.util.SeffAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers. The
 * adapters generated by this factory convert EMF adapter notifications into calls to
 * {@link #fireNotifyChanged fireNotifyChanged}. The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances. <!-- begin-user-doc --> <!--
 * end-user-doc -->
 * 
 * @generated
 */
public class SeffItemProviderAdapterFactory extends SeffAdapterFactory
        implements ComposeableAdapterFactory, IChangeNotifier, IDisposable, IChildCreationExtender {

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public static final String copyright = "Copyright 2005-2017 by palladiosimulator.org";

    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This helps manage the child creation extenders. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager(
            PalladioComponentModelEditPlugin.INSTANCE, SeffPackage.eNS_URI);

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType
     * isFactoryForType}. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object>();

    /**
     * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public SeffItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.seff.StopAction} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @generated
     */
    protected StopActionItemProvider stopActionItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.pcm.seff.StopAction}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createStopActionAdapter() {
        if (this.stopActionItemProvider == null) {
            this.stopActionItemProvider = new StopActionItemProvider(this);
        }

        return this.stopActionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ResourceDemandingBehaviourItemProvider resourceDemandingBehaviourItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createResourceDemandingBehaviourAdapter() {
        if (this.resourceDemandingBehaviourItemProvider == null) {
            this.resourceDemandingBehaviourItemProvider = new ResourceDemandingBehaviourItemProvider(this);
        }

        return this.resourceDemandingBehaviourItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.seff.BranchAction} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @generated
     */
    protected BranchActionItemProvider branchActionItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.pcm.seff.BranchAction}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createBranchActionAdapter() {
        if (this.branchActionItemProvider == null) {
            this.branchActionItemProvider = new BranchActionItemProvider(this);
        }

        return this.branchActionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.seff.StartAction} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @generated
     */
    protected StartActionItemProvider startActionItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.pcm.seff.StartAction}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createStartActionAdapter() {
        if (this.startActionItemProvider == null) {
            this.startActionItemProvider = new StartActionItemProvider(this);
        }

        return this.startActionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.seff.ResourceDemandingSEFF} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected ResourceDemandingSEFFItemProvider resourceDemandingSEFFItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.pcm.seff.ResourceDemandingSEFF}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createResourceDemandingSEFFAdapter() {
        if (this.resourceDemandingSEFFItemProvider == null) {
            this.resourceDemandingSEFFItemProvider = new ResourceDemandingSEFFItemProvider(this);
        }

        return this.resourceDemandingSEFFItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.seff.ResourceDemandingInternalBehaviour} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ResourceDemandingInternalBehaviourItemProvider resourceDemandingInternalBehaviourItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.pcm.seff.ResourceDemandingInternalBehaviour}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createResourceDemandingInternalBehaviourAdapter() {
        if (this.resourceDemandingInternalBehaviourItemProvider == null) {
            this.resourceDemandingInternalBehaviourItemProvider = new ResourceDemandingInternalBehaviourItemProvider(
                    this);
        }

        return this.resourceDemandingInternalBehaviourItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.seff.ReleaseAction} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @generated
     */
    protected ReleaseActionItemProvider releaseActionItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.pcm.seff.ReleaseAction}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createReleaseActionAdapter() {
        if (this.releaseActionItemProvider == null) {
            this.releaseActionItemProvider = new ReleaseActionItemProvider(this);
        }

        return this.releaseActionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.seff.LoopAction} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @generated
     */
    protected LoopActionItemProvider loopActionItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.pcm.seff.LoopAction}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createLoopActionAdapter() {
        if (this.loopActionItemProvider == null) {
            this.loopActionItemProvider = new LoopActionItemProvider(this);
        }

        return this.loopActionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.seff.ForkAction} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @generated
     */
    protected ForkActionItemProvider forkActionItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.pcm.seff.ForkAction}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createForkActionAdapter() {
        if (this.forkActionItemProvider == null) {
            this.forkActionItemProvider = new ForkActionItemProvider(this);
        }

        return this.forkActionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.seff.ForkedBehaviour} instances. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    protected ForkedBehaviourItemProvider forkedBehaviourItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.pcm.seff.ForkedBehaviour}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createForkedBehaviourAdapter() {
        if (this.forkedBehaviourItemProvider == null) {
            this.forkedBehaviourItemProvider = new ForkedBehaviourItemProvider(this);
        }

        return this.forkedBehaviourItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.seff.SynchronisationPoint} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected SynchronisationPointItemProvider synchronisationPointItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.pcm.seff.SynchronisationPoint}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createSynchronisationPointAdapter() {
        if (this.synchronisationPointItemProvider == null) {
            this.synchronisationPointItemProvider = new SynchronisationPointItemProvider(this);
        }

        return this.synchronisationPointItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.seff.ExternalCallAction} instances. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    protected ExternalCallActionItemProvider externalCallActionItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.pcm.seff.ExternalCallAction}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createExternalCallActionAdapter() {
        if (this.externalCallActionItemProvider == null) {
            this.externalCallActionItemProvider = new ExternalCallActionItemProvider(this);
        }

        return this.externalCallActionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.seff.CallReturnAction} instances. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    protected CallReturnActionItemProvider callReturnActionItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.pcm.seff.CallReturnAction}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createCallReturnActionAdapter() {
        if (this.callReturnActionItemProvider == null) {
            this.callReturnActionItemProvider = new CallReturnActionItemProvider(this);
        }

        return this.callReturnActionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ProbabilisticBranchTransitionItemProvider probabilisticBranchTransitionItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createProbabilisticBranchTransitionAdapter() {
        if (this.probabilisticBranchTransitionItemProvider == null) {
            this.probabilisticBranchTransitionItemProvider = new ProbabilisticBranchTransitionItemProvider(this);
        }

        return this.probabilisticBranchTransitionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.seff.AcquireAction} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @generated
     */
    protected AcquireActionItemProvider acquireActionItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.pcm.seff.AcquireAction}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createAcquireActionAdapter() {
        if (this.acquireActionItemProvider == null) {
            this.acquireActionItemProvider = new AcquireActionItemProvider(this);
        }

        return this.acquireActionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.seff.CollectionIteratorAction} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected CollectionIteratorActionItemProvider collectionIteratorActionItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.pcm.seff.CollectionIteratorAction}. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createCollectionIteratorActionAdapter() {
        if (this.collectionIteratorActionItemProvider == null) {
            this.collectionIteratorActionItemProvider = new CollectionIteratorActionItemProvider(this);
        }

        return this.collectionIteratorActionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.seff.GuardedBranchTransition} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected GuardedBranchTransitionItemProvider guardedBranchTransitionItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.pcm.seff.GuardedBranchTransition}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createGuardedBranchTransitionAdapter() {
        if (this.guardedBranchTransitionItemProvider == null) {
            this.guardedBranchTransitionItemProvider = new GuardedBranchTransitionItemProvider(this);
        }

        return this.guardedBranchTransitionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.seff.SetVariableAction} instances. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    protected SetVariableActionItemProvider setVariableActionItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.pcm.seff.SetVariableAction}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createSetVariableActionAdapter() {
        if (this.setVariableActionItemProvider == null) {
            this.setVariableActionItemProvider = new SetVariableActionItemProvider(this);
        }

        return this.setVariableActionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.seff.InternalCallAction} instances. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    protected InternalCallActionItemProvider internalCallActionItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.pcm.seff.InternalCallAction}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createInternalCallActionAdapter() {
        if (this.internalCallActionItemProvider == null) {
            this.internalCallActionItemProvider = new InternalCallActionItemProvider(this);
        }

        return this.internalCallActionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.seff.EmitEventAction} instances. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    protected EmitEventActionItemProvider emitEventActionItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.pcm.seff.EmitEventAction}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createEmitEventActionAdapter() {
        if (this.emitEventActionItemProvider == null) {
            this.emitEventActionItemProvider = new EmitEventActionItemProvider(this);
        }

        return this.emitEventActionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.pcm.seff.InternalAction} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @generated
     */
    protected InternalActionItemProvider internalActionItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.pcm.seff.InternalAction}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createInternalActionAdapter() {
        if (this.internalActionItemProvider == null) {
            this.internalActionItemProvider = new InternalActionItemProvider(this);
        }

        return this.internalActionItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void setParentAdapterFactory(final ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public boolean isFactoryForType(final Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter adapt(final Notifier notifier, final Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Object adapt(final Object object, final Object type) {
        if (this.isFactoryForType(type)) {
            final Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public List<IChildCreationExtender> getChildCreationExtenders() {
        return this.childCreationExtenderManager.getChildCreationExtenders();
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Collection<?> getNewChildDescriptors(final Object object, final EditingDomain editingDomain) {
        return this.childCreationExtenderManager.getNewChildDescriptors(object, editingDomain);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public ResourceLocator getResourceLocator() {
        return this.childCreationExtenderManager;
    }

    /**
     * This adds a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void addListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void removeListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void fireNotifyChanged(final Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);

        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    /**
     * This disposes all of the item providers created by this factory. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void dispose() {
        if (this.stopActionItemProvider != null) {
            this.stopActionItemProvider.dispose();
        }
        if (this.resourceDemandingBehaviourItemProvider != null) {
            this.resourceDemandingBehaviourItemProvider.dispose();
        }
        if (this.branchActionItemProvider != null) {
            this.branchActionItemProvider.dispose();
        }
        if (this.startActionItemProvider != null) {
            this.startActionItemProvider.dispose();
        }
        if (this.resourceDemandingSEFFItemProvider != null) {
            this.resourceDemandingSEFFItemProvider.dispose();
        }
        if (this.resourceDemandingInternalBehaviourItemProvider != null) {
            this.resourceDemandingInternalBehaviourItemProvider.dispose();
        }
        if (this.releaseActionItemProvider != null) {
            this.releaseActionItemProvider.dispose();
        }
        if (this.loopActionItemProvider != null) {
            this.loopActionItemProvider.dispose();
        }
        if (this.forkActionItemProvider != null) {
            this.forkActionItemProvider.dispose();
        }
        if (this.forkedBehaviourItemProvider != null) {
            this.forkedBehaviourItemProvider.dispose();
        }
        if (this.synchronisationPointItemProvider != null) {
            this.synchronisationPointItemProvider.dispose();
        }
        if (this.externalCallActionItemProvider != null) {
            this.externalCallActionItemProvider.dispose();
        }
        if (this.callReturnActionItemProvider != null) {
            this.callReturnActionItemProvider.dispose();
        }
        if (this.probabilisticBranchTransitionItemProvider != null) {
            this.probabilisticBranchTransitionItemProvider.dispose();
        }
        if (this.acquireActionItemProvider != null) {
            this.acquireActionItemProvider.dispose();
        }
        if (this.collectionIteratorActionItemProvider != null) {
            this.collectionIteratorActionItemProvider.dispose();
        }
        if (this.guardedBranchTransitionItemProvider != null) {
            this.guardedBranchTransitionItemProvider.dispose();
        }
        if (this.setVariableActionItemProvider != null) {
            this.setVariableActionItemProvider.dispose();
        }
        if (this.internalCallActionItemProvider != null) {
            this.internalCallActionItemProvider.dispose();
        }
        if (this.emitEventActionItemProvider != null) {
            this.emitEventActionItemProvider.dispose();
        }
        if (this.internalActionItemProvider != null) {
            this.internalActionItemProvider.dispose();
        }
    }

}
