/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom;

import com.google.common.base.Objects;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.palladiosimulator.analyzer.workflow.configurations.AbstractCodeGenerationWorkflowRunConfiguration;
import org.palladiosimulator.protocom.constants.ProtoComConstants;

public class ProtoComProject {
    private static final Logger LOGGER = Logger.getLogger(ProtoComProject.class);
    private final IProgressMonitor monitor = new NullProgressMonitor();
    private final String projectURI;
    private final String filePath;
    private final IProject iProject;
    private final AbstractCodeGenerationWorkflowRunConfiguration.CodeGenerationAdvice projectType;
    private final String[] natures;
    private final String[] builders;
    private final IProjectDescription description;

    public ProtoComProject(String projectURI, String filePath, AbstractCodeGenerationWorkflowRunConfiguration.CodeGenerationAdvice projectType) {
        try {
            IProjectDescription _createDescription;
            IProject _createProject;
            this.projectURI = projectURI;
            this.filePath = filePath;
            this.iProject = _createProject = this.createProject(projectURI, this.monitor);
            this.projectType = projectType;
            String[] _createNatures = this.createNatures();
            this.natures = _createNatures;
            String[] _createBuilders = this.createBuilders();
            this.builders = _createBuilders;
            this.description = _createDescription = this.createDescription();
            try {
                this.iProject.setDescription(this.description, this.monitor);
            }
            catch (Throwable _t) {
                if (_t instanceof CoreException) {
                    CoreException e = (CoreException)_t;
                    throw new JobFailedException("Failed setting Java and PDE nature and builders", (Throwable)e);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public IProject getIProject() {
        return this.iProject;
    }

    public void compile() {
        this.refreshPluginInWorkspace();
        this.buildProject();
        this.checkForErrors();
    }

    private IProject createProject(String projectURI, IProgressMonitor monitor) throws JobFailedException {
        try {
            IWorkspace _workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot _root = _workspace.getRoot();
            IProject iProject = _root.getProject(projectURI);
            boolean _exists = iProject.exists();
            if (_exists) {
                throw new JobFailedException("Tried to create an existing project. Preceeding cleanup failed");
            }
            boolean _isDebugEnabled = LOGGER.isDebugEnabled();
            if (_isDebugEnabled) {
                String _name = iProject.getName();
                String _plus = "Creating Eclipse workspace project " + _name;
                LOGGER.debug((Object)_plus);
            }
            iProject.create(monitor);
            iProject.open(monitor);
            return iProject;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private String[] createNatures() {
        if (Objects.equal((Object)this.projectType, (Object)AbstractCodeGenerationWorkflowRunConfiguration.CodeGenerationAdvice.PROTO) || Objects.equal((Object)this.projectType, (Object)AbstractCodeGenerationWorkflowRunConfiguration.CodeGenerationAdvice.POJO)) {
            return ProtoComConstants.JAVA_SE_NATURE;
        }
        if (Objects.equal((Object)this.projectType, (Object)AbstractCodeGenerationWorkflowRunConfiguration.CodeGenerationAdvice.EJB3) || Objects.equal((Object)this.projectType, (Object)AbstractCodeGenerationWorkflowRunConfiguration.CodeGenerationAdvice.SERVLET)) {
            return ProtoComConstants.JAVA_EE_NATURE;
        }
        throw new RuntimeException("No suitable project natures found (project type is \"" + this.projectType + "\")");
    }

    private String[] createBuilders() {
        if (Objects.equal((Object)this.projectType, (Object)AbstractCodeGenerationWorkflowRunConfiguration.CodeGenerationAdvice.PROTO) || Objects.equal((Object)this.projectType, (Object)AbstractCodeGenerationWorkflowRunConfiguration.CodeGenerationAdvice.POJO)) {
            return ProtoComConstants.JAVA_SE_BUILDERS;
        }
        if (Objects.equal((Object)this.projectType, (Object)AbstractCodeGenerationWorkflowRunConfiguration.CodeGenerationAdvice.EJB3) || Objects.equal((Object)this.projectType, (Object)AbstractCodeGenerationWorkflowRunConfiguration.CodeGenerationAdvice.SERVLET)) {
            return ProtoComConstants.JAVA_EE_BUILDERS;
        }
        throw new RuntimeException("No suitable project builders found (project type is \"" + this.projectType + "\")");
    }

    private IProjectDescription createDescription() throws JobFailedException {
        IWorkspace _workspace = ResourcesPlugin.getWorkspace();
        String _name = this.iProject.getName();
        IProjectDescription description = _workspace.newProjectDescription(_name);
        description.setNatureIds(this.natures);
        description.setLocation(null);
        ArrayList buildCommands = CollectionLiterals.newArrayList((Object[])new ICommand[0]);
        String[] stringArray = this.builders;
        int n = this.builders.length;
        int n2 = 0;
        while (n2 < n) {
            String builder = stringArray[n2];
            ICommand command = description.newCommand();
            command.setBuilderName(builder);
            buildCommands.add(command);
            ++n2;
        }
        description.setBuildSpec((ICommand[])Conversions.unwrapArray((Object)buildCommands, ICommand.class));
        return description;
    }

    private void refreshPluginInWorkspace() {
        try {
            try {
                this.iProject.refreshLocal(2, this.monitor);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    throw new JobFailedException("Refreshing plugin project failed", (Throwable)e);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void buildProject() {
        try {
            try {
                this.iProject.build(6, this.monitor);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    throw new JobFailedException("Building plugin project failed", (Throwable)e);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void checkForErrors() {
        try {
            try {
                boolean _greaterThan;
                IMarker[] _findMarkers = this.iProject.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                int _length = _findMarkers.length;
                boolean bl = _greaterThan = _length > 0;
                if (_greaterThan) {
                    boolean failed = false;
                    IMarker[] markers = this.iProject.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                    String errorList = "";
                    IMarker[] iMarkerArray = markers;
                    int n = markers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarker marker = iMarkerArray[n2];
                        Object _attribute = marker.getAttribute("severity");
                        boolean _equals = Objects.equal((Object)_attribute, (Object)2);
                        if (_equals) {
                            String _plus_1;
                            Object _attribute_1 = marker.getAttribute("message");
                            String _plus = String.valueOf(errorList) + _attribute_1;
                            errorList = _plus_1 = String.valueOf(_plus) + "\n";
                            failed = true;
                        }
                        ++n2;
                    }
                    if (failed) {
                        LOGGER.error((Object)("Unable to build a simulation plug-in; trying to continue. Failure Messages: " + errorList));
                    }
                }
            }
            catch (Throwable _t) {
                if (_t instanceof CoreException) {
                    CoreException e = (CoreException)_t;
                    throw new JobFailedException("Compile Plugin failed. Error finding project markers.", (Throwable)e);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

