/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.servicelevelobjective.edp2.visualization.jfreechart.input.servicelevelobjective;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.Collections;
import java.util.Set;
import javax.measure.Measure;
import javax.measure.unit.Unit;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.IDataStream;
import org.palladiosimulator.edp2.datastream.configurable.PropertyConfigurable;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.edp2.visualization.jfreechart.input.AbstractXYVisualizationInput;
import org.palladiosimulator.edp2.visualization.jfreechart.input.JFreeChartVisualizationSingleDatastreamInput;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.servicelevelobjective.LinearFuzzyThreshold;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjective;
import org.palladiosimulator.servicelevelobjective.edp2.SLOEDP2UIPlugin;
import org.palladiosimulator.servicelevelobjective.edp2.visualization.jfreechart.input.servicelevelobjective.SLOQuantitativePlotInputConfiguration;
import org.palladiosimulator.servicelevelobjective.edp2.visualization.jfreechart.input.servicelevelobjective.SLOQuantitativePlotInputFactory;
import org.palladiosimulator.servicelevelobjective.edp2.visualization.wizards.SLOViewsWizard;

public class SLOQuantitativePlotInput
extends AbstractXYVisualizationInput {
    private double[][] aggregatedData;
    private ServiceLevelObjective slo;
    private String measuringPointLabel;

    public String getFactoryId() {
        return SLOQuantitativePlotInputFactory.FACTORY_ID;
    }

    public boolean canAccept(IDataSource source) {
        BaseMetricDescription[] mds = MetricDescriptionUtility.toBaseMetricDescriptions((MetricDescription)source.getMetricDesciption());
        if (mds.length != 2) {
            return false;
        }
        BaseMetricDescription[] baseMetricDescriptionArray = mds;
        int n = mds.length;
        int n2 = 0;
        while (n2 < n) {
            BaseMetricDescription md = baseMetricDescriptionArray[n2];
            if (!(md instanceof NumericalBaseMetricDescription)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected PropertyConfigurable createConfiguration() {
        return new SLOQuantitativePlotInputConfiguration();
    }

    protected AbstractDataset generateDataset() {
        DefaultXYDataset dataset = new DefaultXYDataset();
        int i = 1;
        for (JFreeChartVisualizationSingleDatastreamInput childInput : this.getInputs()) {
            dataset.addSeries((Comparable)((Object)(String.valueOf(i) + ": " + childInput.getInputName())), this.getXYData(childInput.getDataSource()));
            ++i;
        }
        return dataset;
    }

    protected Plot generatePlot(PropertyConfigurable config, AbstractDataset dataset) {
        SLOViewsWizard wizard = new SLOViewsWizard(this.getInputs());
        WizardDialog wdialog = new WizardDialog(SLOEDP2UIPlugin.INSTANCE.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        wdialog.open();
        this.slo = wizard.getSelectedSLO();
        if (this.slo == null) {
            return null;
        }
        DefaultXYDataset xyDataset = (DefaultXYDataset)dataset;
        DefaultXYDataset thresholdDataset = new DefaultXYDataset();
        SLOQuantitativePlotInputConfiguration configuration = (SLOQuantitativePlotInputConfiguration)config;
        XYPlot plot = new XYPlot();
        NumberAxis domainAxis = new NumberAxis(configuration.isShowDomainAxisLabel() ? configuration.getDomainAxisLabel() : null);
        NumberAxis rangeAxis = new NumberAxis(configuration.isShowRangeAxisLabel() ? configuration.getRangeAxisLabel() : null);
        plot.setRangeAxis((ValueAxis)rangeAxis);
        plot.setDomainAxis((ValueAxis)domainAxis);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesLinesVisible(0, configuration.isShowSeriesLine());
        renderer.setSeriesShapesVisible(0, configuration.isShowSeriesShapes());
        XYLineAndShapeRenderer thresholdDatasetRenderer = new XYLineAndShapeRenderer();
        thresholdDatasetRenderer.setSeriesPaint(0, (Paint)Color.MAGENTA);
        thresholdDatasetRenderer.setSeriesStroke(0, (Stroke)new BasicStroke(4.0f));
        thresholdDatasetRenderer.setSeriesPaint(1, (Paint)Color.BLACK);
        thresholdDatasetRenderer.setSeriesStroke(1, (Stroke)new BasicStroke(4.0f));
        double[][] upperThresholdData = new double[2][2];
        double[][] softUpperThresholdData = new double[2][2];
        double[][] lowerThresholdData = new double[2][2];
        double[][] softLowerThresholdData = new double[2][2];
        Unit unit = this.slo.getUpperThreshold().getThresholdLimit().getUnit();
        lowerThresholdData[0][0] = 0.0;
        lowerThresholdData[0][1] = xyDataset.getXValue(0, xyDataset.getItemCount(0) - 1);
        lowerThresholdData[1][0] = this.slo.getLowerThreshold().getThresholdLimit().doubleValue(unit);
        lowerThresholdData[1][1] = this.slo.getLowerThreshold().getThresholdLimit().doubleValue(unit);
        upperThresholdData[0][0] = 0.0;
        upperThresholdData[0][1] = xyDataset.getXValue(0, xyDataset.getItemCount(0) - 1);
        upperThresholdData[1][0] = this.slo.getUpperThreshold().getThresholdLimit().doubleValue(unit);
        upperThresholdData[1][1] = this.slo.getUpperThreshold().getThresholdLimit().doubleValue(unit);
        thresholdDataset.addSeries((Comparable)((Object)"Lower Threshold"), lowerThresholdData);
        thresholdDataset.addSeries((Comparable)((Object)"Upper Threshold"), upperThresholdData);
        if (this.slo.getLowerThreshold() instanceof LinearFuzzyThreshold) {
            softLowerThresholdData[0][0] = 0.0;
            softLowerThresholdData[0][1] = xyDataset.getXValue(0, xyDataset.getItemCount(0) - 1);
            softLowerThresholdData[1][0] = ((LinearFuzzyThreshold)this.slo.getLowerThreshold()).getSoftLimit().doubleValue(unit);
            softLowerThresholdData[1][1] = ((LinearFuzzyThreshold)this.slo.getLowerThreshold()).getSoftLimit().doubleValue(unit);
            thresholdDataset.addSeries((Comparable)((Object)"Soft Lower Threshold"), softLowerThresholdData);
            thresholdDatasetRenderer.setSeriesPaint(2, (Paint)Color.MAGENTA);
        }
        if (this.slo.getUpperThreshold() instanceof LinearFuzzyThreshold) {
            softUpperThresholdData[0][0] = 0.0;
            softUpperThresholdData[0][1] = xyDataset.getXValue(0, xyDataset.getItemCount(0) - 1);
            softUpperThresholdData[1][0] = ((LinearFuzzyThreshold)this.slo.getUpperThreshold()).getSoftLimit().doubleValue(unit);
            softUpperThresholdData[1][1] = ((LinearFuzzyThreshold)this.slo.getUpperThreshold()).getSoftLimit().doubleValue(unit);
            thresholdDataset.addSeries((Comparable)((Object)"Soft Upper Threshold"), softUpperThresholdData);
            thresholdDatasetRenderer.setSeriesPaint(3, (Paint)Color.BLACK);
        }
        if (this.aggregatedData != null) {
            DefaultXYDataset aggData = new DefaultXYDataset();
            aggData.addSeries((Comparable)((Object)("Service Level Objective \"" + this.slo.getName() + "\". " + "Measuring points: " + this.measuringPointLabel)), this.aggregatedData);
            plot.setDataset(0, (XYDataset)aggData);
        } else {
            plot.setDataset(0, (XYDataset)xyDataset);
        }
        plot.setDataset(1, (XYDataset)thresholdDataset);
        plot.setRenderer(0, (XYItemRenderer)renderer);
        plot.setRenderer(1, (XYItemRenderer)thresholdDatasetRenderer);
        plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        this.configureSeriesColors((AbstractRenderer)renderer);
        return plot;
    }

    private double[][] getXYData(IDataSource dataSource) {
        if (!this.canAccept(dataSource)) {
            throw new IllegalArgumentException("XYData has to be a two-dimensional metric set description.");
        }
        IDataStream inputStream = dataSource.getDataStream();
        EList subsumedMetrics = ((MetricSetDescription)inputStream.getMetricDesciption()).getSubsumedMetrics();
        Unit domainUnit = ((NumericalBaseMetricDescription)subsumedMetrics.get(this.getXPos())).getDefaultUnit();
        Unit rangeUnit = ((NumericalBaseMetricDescription)subsumedMetrics.get(this.getYPos())).getDefaultUnit();
        try {
            double[][] result = new double[2][inputStream.size()];
            int i = 0;
            for (TupleMeasurement tuple : inputStream) {
                Measure[] measurement = tuple.asArray();
                result[0][i] = measurement[this.getXPos()].doubleValue(domainUnit);
                result[1][i] = measurement[this.getYPos()].doubleValue(rangeUnit);
                ++i;
            }
            double[][] dArray = result;
            return dArray;
        }
        finally {
            inputStream.close();
        }
    }

    protected Set<String> getPropertyKeysTriggeringUpdate() {
        return Collections.emptySet();
    }

    public void setAggregatedData(double[][] aggregatedData) {
        this.aggregatedData = aggregatedData;
    }

    public void setSlo(ServiceLevelObjective slo) {
        this.slo = slo;
    }

    public void setMeasuringPointLabel(String measuringPointLabel) {
        this.measuringPointLabel = measuringPointLabel;
    }
}

