/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.servicelevelobjective.edp2.visualization.wizards;

import javax.measure.Measure;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.edp2.visualization.wizards.IncorrectThresholdInputException;
import org.palladiosimulator.servicelevelobjective.LinearFuzzyThreshold;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjective;
import org.palladiosimulator.servicelevelobjective.Threshold;
import org.palladiosimulator.servicelevelobjective.edp2.visualization.wizards.SLOViewsWizard;

public class SLODialogSpecifiySLOThresholdsPage
extends WizardPage
implements SelectionListener {
    private double selectedTimestepInterval = 10.0;
    private Scale scale;
    private ServiceLevelObjective selectedSLO;
    private Measure<?, Quantity> hardLowerThreshold;
    private Measure<?, Quantity> hardUpperThreshold;
    private Measure<?, Quantity> softLowerThreshold;
    private Measure<?, Quantity> softUpperThreshold;
    private boolean hardLowerThresholdSet = false;
    private boolean hardUpperThresholdSet = false;
    private boolean softLowerThresholdSet = false;
    private boolean softUpperThresholdSet = false;
    Label labelUpperThreshold;
    Text textUpperThreshold;
    Label labelLowerThreshold;
    Text textLowerThreshold;
    Label labelSoftUpperThreshold;
    Text textSoftUpperThreshold;
    Label labelSoftLowerThreshold;
    Text textSoftLowerThreshold;
    private IStatus inputStatus;
    private final Status statusOK;

    protected SLODialogSpecifiySLOThresholdsPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
        this.setDescription("Please specify the lower and upper thresholds of the Service Level Objective.");
        this.inputStatus = new Status(1, "not_used", 0, "Please specify the lower and upper thresholds of the Service Level Objective.", null);
        this.statusOK = new Status(0, "not_used", 0, "", null);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        composite.setLayout((Layout)gl);
        this.labelLowerThreshold = new Label(composite, 0);
        this.labelLowerThreshold.setText("Lower threshold: []: ");
        this.textLowerThreshold = new Text(composite, 2052);
        ControlDecoration decorLower = new ControlDecoration((Control)this.textLowerThreshold, 0x1000000);
        this.textLowerThreshold.addListener(24, (Listener)new InputListener(this.textLowerThreshold, decorLower, "hardLowerThresholdSet"));
        this.labelUpperThreshold = new Label(composite, 0);
        this.labelUpperThreshold.setText("Upper threshold: []: ");
        this.textUpperThreshold = new Text(composite, 2052);
        ControlDecoration decorUpper = new ControlDecoration((Control)this.textUpperThreshold, 0x1000000);
        this.textUpperThreshold.addListener(24, (Listener)new InputListener(this.textUpperThreshold, decorUpper, "hardUpperThresholdSet"));
        this.labelSoftUpperThreshold = new Label(composite, 0);
        this.labelSoftUpperThreshold.setVisible(false);
        this.labelSoftUpperThreshold.setText("Soft upper threshold: []: ");
        this.textSoftUpperThreshold = new Text(composite, 2052);
        this.textSoftUpperThreshold.setVisible(false);
        ControlDecoration decorSoftUpper = new ControlDecoration((Control)this.textSoftUpperThreshold, 0x1000000);
        this.textSoftUpperThreshold.addListener(24, (Listener)new InputListener(this.textSoftUpperThreshold, decorSoftUpper, "softUpperThresholdSet"));
        this.labelSoftLowerThreshold = new Label(composite, 0);
        this.labelSoftLowerThreshold.setVisible(false);
        this.labelSoftLowerThreshold.setText("Soft lower threshold: []: ");
        this.textSoftLowerThreshold = new Text(composite, 2052);
        this.textSoftLowerThreshold.setVisible(false);
        ControlDecoration decorSoftLower = new ControlDecoration((Control)this.textSoftLowerThreshold, 0x1000000);
        this.textSoftLowerThreshold.addListener(24, (Listener)new InputListener(this.textSoftLowerThreshold, decorSoftLower, "softLowerThresholdSet"));
        Label scaleLabel = new Label(composite, 0);
        scaleLabel.setText("Specify the time interval for qualitative Service Level Objective fulfillment calculation [s]:");
        this.scale = new Scale(composite, 0);
        this.scale.setSelection(10);
        this.scale.setMinimum(1);
        this.scale.setToolTipText("" + this.scale.getSelection());
        this.scale.addSelectionListener((SelectionListener)this);
        this.setControl((Control)composite);
    }

    private void checkInputForCorrectness() throws IncorrectThresholdInputException {
        if (this.hardLowerThreshold != null && this.hardUpperThreshold != null && this.hardLowerThreshold.compareTo(this.hardUpperThreshold) > 0) {
            throw new IncorrectThresholdInputException("Hard lower threshold higher than hard upper threshold");
        }
        if (this.softLowerThreshold != null && this.hardLowerThreshold != null && this.hardUpperThreshold != null && this.softUpperThreshold != null) {
            if (this.softUpperThreshold.compareTo(this.hardUpperThreshold) > 0) {
                throw new IncorrectThresholdInputException("Soft upper threshold higher than hard upper threshold");
            }
            if (this.hardLowerThreshold.compareTo(this.softLowerThreshold) > 0) {
                throw new IncorrectThresholdInputException("Hard lower threshold higher than soft lower threshold");
            }
            if (this.softUpperThreshold.compareTo(this.softLowerThreshold) < 0) {
                throw new IncorrectThresholdInputException("Soft lower threshold higher than soft upper threshold");
            }
            if (this.softUpperThreshold.compareTo(this.hardLowerThreshold) < 0) {
                throw new IncorrectThresholdInputException("Hard lower threshold higher than soft upper threshold");
            }
            if (this.softLowerThreshold.compareTo(this.hardUpperThreshold) > 0) {
                throw new IncorrectThresholdInputException("Soft lower threshold higher than hard upper threshold");
            }
            this.softLowerThresholdSet = true;
            this.softUpperThresholdSet = true;
        }
        this.hardLowerThresholdSet = true;
        this.hardUpperThresholdSet = true;
    }

    public IStatus updatePageStatus() {
        Status pageStatus = this.statusOK;
        ((SLOViewsWizard)this.getWizard()).setFinishable(false);
        switch (this.inputStatus.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(this.inputStatus.getMessage());
                pageStatus = this.statusOK;
                this.setPageComplete(true);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(this.inputStatus.getMessage(), 2);
                pageStatus = this.inputStatus;
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(this.inputStatus.getMessage(), 1);
                pageStatus = this.inputStatus;
                break;
            }
            default: {
                this.setErrorMessage(this.inputStatus.getMessage());
                this.setMessage(null);
                pageStatus = this.inputStatus;
            }
        }
        this.getContainer().updateButtons();
        return pageStatus;
    }

    public void setSelectedSLO(ServiceLevelObjective selectedSLO) {
        this.selectedSLO = selectedSLO;
        Threshold lowerThreshold = selectedSLO.getLowerThreshold();
        Threshold upperThreshold = selectedSLO.getUpperThreshold();
        if (lowerThreshold instanceof LinearFuzzyThreshold) {
            this.softLowerThreshold = ((LinearFuzzyThreshold)lowerThreshold).getSoftLimit();
            this.labelSoftLowerThreshold.setText("Soft lower threshold: [" + this.softLowerThreshold.getUnit().toString() + "]: ");
            this.labelSoftLowerThreshold.setVisible(true);
            Double softLowerThresholdDouble = this.softLowerThreshold.doubleValue(this.softLowerThreshold.getUnit());
            if (!this.textSoftLowerThreshold.getText().equalsIgnoreCase(softLowerThresholdDouble.toString())) {
                this.textSoftLowerThreshold.setText(softLowerThresholdDouble.toString());
                this.softLowerThresholdSet = true;
            }
            if (!this.textSoftLowerThreshold.getText().equalsIgnoreCase("")) {
                this.softLowerThresholdSet = true;
            }
            this.textSoftLowerThreshold.setVisible(true);
        } else {
            this.softLowerThreshold = null;
            this.softLowerThresholdSet = false;
            this.labelSoftLowerThreshold.setVisible(false);
            this.textSoftLowerThreshold.setVisible(false);
        }
        if (upperThreshold instanceof LinearFuzzyThreshold) {
            this.softUpperThreshold = ((LinearFuzzyThreshold)upperThreshold).getSoftLimit();
            this.labelSoftUpperThreshold.setText("Soft upper threshold: [" + this.softUpperThreshold.getUnit().toString() + "]: ");
            Double softUpperThresholdDouble = this.softUpperThreshold.doubleValue(this.softUpperThreshold.getUnit());
            if (!this.textSoftUpperThreshold.getText().equalsIgnoreCase(softUpperThresholdDouble.toString())) {
                this.textSoftUpperThreshold.setText(softUpperThresholdDouble.toString());
                this.softUpperThresholdSet = true;
            }
            if (!this.textSoftUpperThreshold.getText().equalsIgnoreCase("")) {
                this.softUpperThresholdSet = true;
            }
            this.labelSoftUpperThreshold.setVisible(true);
            this.textSoftUpperThreshold.setVisible(true);
        } else {
            this.softUpperThreshold = null;
            this.softUpperThresholdSet = false;
            this.labelSoftUpperThreshold.setVisible(false);
            this.textSoftUpperThreshold.setVisible(false);
        }
        this.hardLowerThreshold = lowerThreshold.getThresholdLimit();
        this.hardUpperThreshold = upperThreshold.getThresholdLimit();
        this.labelUpperThreshold.setText("Upper threshold: [" + this.hardUpperThreshold.getUnit().toString() + "]: ");
        this.labelUpperThreshold.setVisible(true);
        Double hardUpperThresholdDouble = this.hardUpperThreshold.doubleValue(this.hardUpperThreshold.getUnit());
        if (!this.textUpperThreshold.getText().equalsIgnoreCase(hardUpperThresholdDouble.toString())) {
            this.textUpperThreshold.setText(hardUpperThresholdDouble.toString());
            this.hardUpperThresholdSet = true;
        }
        this.textUpperThreshold.setVisible(true);
        this.labelLowerThreshold.setText("Lower threshold: [" + this.hardLowerThreshold.getUnit().toString() + "]: ");
        this.labelLowerThreshold.setVisible(true);
        Double hardLowerThresholdDouble = this.hardLowerThreshold.doubleValue(this.hardLowerThreshold.getUnit());
        if (!this.textLowerThreshold.getText().equalsIgnoreCase(hardLowerThresholdDouble.toString())) {
            this.textLowerThreshold.setText(hardLowerThresholdDouble.toString());
            this.hardLowerThresholdSet = true;
        }
        this.textLowerThreshold.setVisible(true);
        if (lowerThreshold instanceof LinearFuzzyThreshold && upperThreshold instanceof LinearFuzzyThreshold) {
            if (this.hardUpperThresholdSet && this.hardLowerThresholdSet && this.softUpperThresholdSet && this.softLowerThresholdSet) {
                try {
                    this.checkInputForCorrectness();
                    this.setPageComplete(true);
                }
                catch (IncorrectThresholdInputException e) {
                    this.inputStatus = new Status(4, "not_used", 0, "Thresholds loaded from model are incorrect.", null);
                }
            } else {
                this.setPageComplete(false);
            }
        }
        if (lowerThreshold instanceof LinearFuzzyThreshold && !(upperThreshold instanceof LinearFuzzyThreshold)) {
            this.softUpperThresholdSet = false;
            if (this.hardUpperThresholdSet && this.hardLowerThresholdSet && this.softLowerThresholdSet) {
                try {
                    this.checkInputForCorrectness();
                    this.setPageComplete(true);
                }
                catch (IncorrectThresholdInputException e) {
                    this.inputStatus = new Status(4, "not_used", 0, "Thresholds loaded from model are incorrect.", null);
                }
            } else {
                this.setPageComplete(false);
            }
        }
        if (upperThreshold instanceof LinearFuzzyThreshold && !(lowerThreshold instanceof LinearFuzzyThreshold)) {
            this.softLowerThresholdSet = false;
            if (this.hardUpperThresholdSet && this.hardLowerThresholdSet && this.softUpperThresholdSet) {
                try {
                    this.checkInputForCorrectness();
                    this.setPageComplete(true);
                }
                catch (IncorrectThresholdInputException e) {
                    this.inputStatus = new Status(4, "not_used", 0, "Thresholds loaded from model are incorrect.", null);
                }
            } else {
                this.setPageComplete(false);
            }
        }
        if (!(upperThreshold instanceof LinearFuzzyThreshold) && !(lowerThreshold instanceof LinearFuzzyThreshold)) {
            this.softLowerThresholdSet = false;
            this.softUpperThresholdSet = false;
            if (this.hardUpperThresholdSet && this.hardLowerThresholdSet) {
                try {
                    this.checkInputForCorrectness();
                    this.setPageComplete(true);
                }
                catch (IncorrectThresholdInputException e) {
                    this.inputStatus = new Status(4, "not_used", 0, "Thresholds loaded from model are incorrect.", null);
                }
            } else {
                this.setPageComplete(false);
            }
        }
    }

    protected void setMaxSimulationTime(double max) {
        this.scale.setMaximum((int)max);
    }

    public void widgetSelected(SelectionEvent e) {
        this.selectedTimestepInterval = this.scale.getSelection();
        this.scale.setToolTipText("" + this.scale.getSelection());
        ((SLOViewsWizard)this.getWizard()).setSelectedTimestepInterval(this.selectedTimestepInterval);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private class InputListener
    implements Listener {
        private final Text textInput;
        private final ControlDecoration controlDecoration;
        private final String thresholdReference;

        public InputListener(Text text, ControlDecoration controlDecoration, String thresholdReference) {
            this.textInput = text;
            this.controlDecoration = controlDecoration;
            this.thresholdReference = thresholdReference;
        }

        public void handleEvent(Event event) {
            try {
                String text = this.textInput.getText();
                double value = Double.valueOf(text);
                this.controlDecoration.hide();
                if (this.thresholdReference.equals("hardLowerThresholdSet")) {
                    SLODialogSpecifiySLOThresholdsPage.this.hardLowerThresholdSet = true;
                    SLODialogSpecifiySLOThresholdsPage.this.hardLowerThreshold = Measure.valueOf((double)value, (Unit)SLODialogSpecifiySLOThresholdsPage.this.hardLowerThreshold.getUnit());
                    SLODialogSpecifiySLOThresholdsPage.this.selectedSLO.getLowerThreshold().setThresholdLimit(SLODialogSpecifiySLOThresholdsPage.this.hardLowerThreshold);
                    SLODialogSpecifiySLOThresholdsPage.this.checkInputForCorrectness();
                }
                if (this.thresholdReference.equals("hardUpperThresholdSet")) {
                    SLODialogSpecifiySLOThresholdsPage.this.hardUpperThresholdSet = true;
                    SLODialogSpecifiySLOThresholdsPage.this.hardUpperThreshold = Measure.valueOf((double)value, (Unit)SLODialogSpecifiySLOThresholdsPage.this.hardUpperThreshold.getUnit());
                    SLODialogSpecifiySLOThresholdsPage.this.selectedSLO.getUpperThreshold().setThresholdLimit(SLODialogSpecifiySLOThresholdsPage.this.hardUpperThreshold);
                    SLODialogSpecifiySLOThresholdsPage.this.checkInputForCorrectness();
                }
                if (this.thresholdReference.equals("softUpperThresholdSet")) {
                    SLODialogSpecifiySLOThresholdsPage.this.softUpperThresholdSet = true;
                    SLODialogSpecifiySLOThresholdsPage.this.softUpperThreshold = Measure.valueOf((double)value, (Unit)SLODialogSpecifiySLOThresholdsPage.this.softUpperThreshold.getUnit());
                    if (SLODialogSpecifiySLOThresholdsPage.this.selectedSLO.getUpperThreshold() instanceof LinearFuzzyThreshold) {
                        ((LinearFuzzyThreshold)SLODialogSpecifiySLOThresholdsPage.this.selectedSLO.getUpperThreshold()).setSoftLimit(SLODialogSpecifiySLOThresholdsPage.this.softUpperThreshold);
                    }
                    SLODialogSpecifiySLOThresholdsPage.this.checkInputForCorrectness();
                }
                if (this.thresholdReference.equals("softLowerThresholdSet")) {
                    SLODialogSpecifiySLOThresholdsPage.this.softLowerThresholdSet = true;
                    SLODialogSpecifiySLOThresholdsPage.this.softLowerThreshold = Measure.valueOf((double)value, (Unit)SLODialogSpecifiySLOThresholdsPage.this.softLowerThreshold.getUnit());
                    if (SLODialogSpecifiySLOThresholdsPage.this.selectedSLO.getLowerThreshold() instanceof LinearFuzzyThreshold) {
                        ((LinearFuzzyThreshold)SLODialogSpecifiySLOThresholdsPage.this.selectedSLO.getLowerThreshold()).setSoftLimit(SLODialogSpecifiySLOThresholdsPage.this.softLowerThreshold);
                    }
                    SLODialogSpecifiySLOThresholdsPage.this.checkInputForCorrectness();
                }
                if (SLODialogSpecifiySLOThresholdsPage.this.hardLowerThresholdSet && SLODialogSpecifiySLOThresholdsPage.this.hardUpperThresholdSet && SLODialogSpecifiySLOThresholdsPage.this.softLowerThreshold == null && SLODialogSpecifiySLOThresholdsPage.this.softUpperThreshold == null || SLODialogSpecifiySLOThresholdsPage.this.hardLowerThresholdSet && SLODialogSpecifiySLOThresholdsPage.this.hardUpperThresholdSet && SLODialogSpecifiySLOThresholdsPage.this.softLowerThresholdSet && SLODialogSpecifiySLOThresholdsPage.this.softUpperThreshold == null || SLODialogSpecifiySLOThresholdsPage.this.hardLowerThresholdSet && SLODialogSpecifiySLOThresholdsPage.this.hardUpperThresholdSet && SLODialogSpecifiySLOThresholdsPage.this.softLowerThreshold == null && SLODialogSpecifiySLOThresholdsPage.this.softUpperThresholdSet || SLODialogSpecifiySLOThresholdsPage.this.hardLowerThresholdSet && SLODialogSpecifiySLOThresholdsPage.this.hardUpperThresholdSet && SLODialogSpecifiySLOThresholdsPage.this.softLowerThresholdSet && SLODialogSpecifiySLOThresholdsPage.this.softUpperThresholdSet) {
                    SLODialogSpecifiySLOThresholdsPage.this.setPageComplete(true);
                    SLODialogSpecifiySLOThresholdsPage.this.inputStatus = (IStatus)SLODialogSpecifiySLOThresholdsPage.this.statusOK;
                    SLODialogSpecifiySLOThresholdsPage.this.updatePageStatus();
                } else {
                    SLODialogSpecifiySLOThresholdsPage.this.inputStatus = (IStatus)new Status(1, "not used", "Please specify all thresholds.");
                    SLODialogSpecifiySLOThresholdsPage.this.updatePageStatus();
                }
            }
            catch (NumberFormatException e) {
                if (this.thresholdReference.equals("hardLowerThresholdSet")) {
                    SLODialogSpecifiySLOThresholdsPage.this.hardLowerThresholdSet = false;
                }
                if (this.thresholdReference.equals("softLowerThresholdSet")) {
                    SLODialogSpecifiySLOThresholdsPage.this.softLowerThresholdSet = false;
                }
                if (this.thresholdReference.equals("hardUpperThresholdSet")) {
                    SLODialogSpecifiySLOThresholdsPage.this.hardUpperThresholdSet = false;
                }
                if (this.thresholdReference.equals("softUpperThresholdSet")) {
                    SLODialogSpecifiySLOThresholdsPage.this.softUpperThresholdSet = false;
                }
                SLODialogSpecifiySLOThresholdsPage.this.inputStatus = (IStatus)new Status(4, "not_used", 0, "Non empty values of type double required.", null);
                SLODialogSpecifiySLOThresholdsPage.this.setPageComplete(false);
                this.controlDecoration.setDescriptionText("Not a valid input");
                Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
                this.controlDecoration.setImage(image);
                this.controlDecoration.setShowOnlyOnFocus(false);
                this.controlDecoration.show();
                this.controlDecoration.showHoverText("Not a valid input");
                SLODialogSpecifiySLOThresholdsPage.this.updatePageStatus();
            }
            catch (IncorrectThresholdInputException e) {
                SLODialogSpecifiySLOThresholdsPage.this.hardLowerThresholdSet = false;
                SLODialogSpecifiySLOThresholdsPage.this.hardUpperThresholdSet = false;
                SLODialogSpecifiySLOThresholdsPage.this.softLowerThresholdSet = false;
                SLODialogSpecifiySLOThresholdsPage.this.softUpperThresholdSet = false;
                SLODialogSpecifiySLOThresholdsPage.this.inputStatus = (IStatus)new Status(4, "not_used", 0, "Non empty values of type double required.", null);
                SLODialogSpecifiySLOThresholdsPage.this.setPageComplete(false);
                this.controlDecoration.setDescriptionText(e.getMessage());
                Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
                this.controlDecoration.setImage(image);
                this.controlDecoration.setShowOnlyOnFocus(false);
                this.controlDecoration.show();
                this.controlDecoration.showHoverText(e.getMessage());
                SLODialogSpecifiySLOThresholdsPage.this.updatePageStatus();
            }
        }
    }
}

