/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.servicelevelobjective.edp2.visualization.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.chaindescription.ChainDescription;
import org.palladiosimulator.edp2.datastream.configurable.IPropertyConfigurable;
import org.palladiosimulator.edp2.datastream.filter.AbstractAdapter;
import org.palladiosimulator.edp2.visualization.AbstractVisualizationInput;
import org.palladiosimulator.edp2.visualization.wizards.SelectDefaultCombinationsPage;
import org.palladiosimulator.servicelevelobjective.edp2.visualization.wizards.SLOViewsWizard;

public class SLOSelectDefaultCombinationsPage
extends WizardPage
implements ISelectionChangedListener {
    private ChainDescription selectedDescription;
    private static final Logger LOGGER = Logger.getLogger(SelectDefaultCombinationsPage.class.getCanonicalName());
    private static final String DATASINK_EXTENSION_POINT_ID = "org.palladiosimulator.edp2.visualization.datasink";
    private static final String CHAIN_DESCRIPTION_EXTENSION_POINT_ID = "org.palladiosimulator.edp2.datastream.chainDescription";
    private static final String ELEMENT_ID_DATASINK = "datasink";
    private static final String ELEMENT_ID_FILTER = "filter";
    private static final String ELEMENT_ID_PROPERTY = "property";
    private static final String PROPERTY_KEY_ATTRIBUTE = "key";
    private static final String PROPERTY_VALUE_ATTRIBUTE = "value";
    private static final String DATASINK_ID_ATTRIBUTE = "sinkID";
    private static final String FILTER_CLASS_ATTRIBUTE = "filterClass";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String ID_ATTRIBUTE = "id";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String SLO_VISUALIZATION_QUANTITATVE = "SLOQuantitative";
    private static final String SLO_VISUALIZATION_QUALITATIVE = "SLOQualitative";
    private IDataSource selectedSource;
    private IStatus selectionStatus;
    private final Status statusOK;
    private TableViewer choiceViewer;
    private boolean showSLOonly;
    private List<ChainDescription> applicableSequences;

    protected SLOSelectDefaultCombinationsPage(String pageName) {
        super(pageName);
        this.setDescription("Choose a combination of Filters/Adapters + Editor to display the selected Data.");
        this.statusOK = new Status(0, "not_used", 0, "", null);
        this.selectionStatus = new Status(1, "not_used", 0, "Please select a Visualization to proceed.", null);
    }

    protected SLOSelectDefaultCombinationsPage(String pageName, IDataSource selectedSource) {
        super(pageName);
        this.selectedSource = selectedSource;
        this.applicableSequences = this.getApplicableSequences();
        this.setDescription("Choose a combination of Filters/Adapters + Editor to display the selected Data.");
        this.statusOK = new Status(0, "not_used", 0, "", null);
        this.selectionStatus = new Status(1, "not_used", 0, "Please select a Visualization to proceed.", null);
    }

    public boolean canFlipToNextPage() {
        if (this.selectedDescription != null) {
            return this.selectedDescription.getChainID().contains(SLO_VISUALIZATION_QUALITATIVE) || this.selectedDescription.getChainID().contains(SLO_VISUALIZATION_QUANTITATVE);
        }
        return this.selectionStatus.isOK();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        composite.setLayout((Layout)gl);
        Label label = new Label(composite, 0);
        label.setText("Available Choices:");
        SashForm sashForm = new SashForm(composite, 256);
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        sashForm.setLayoutData((Object)gd);
        this.choiceViewer = new TableViewer((Composite)sashForm, 2048);
        this.initializeChoiceViewer();
        this.setControl((Control)composite);
    }

    private void initializeChoiceViewer() {
        this.choiceViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return SLOSelectDefaultCombinationsPage.this.applicableSequences.toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.choiceViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element != null) {
                    ChainDescription sequenceElement = (ChainDescription)element;
                    return sequenceElement.getChainName();
                }
                return null;
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.choiceViewer.setInput(this.applicableSequences);
        this.choiceViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private List<ChainDescription> getApplicableSequences() {
        List<ChainDescription> chainDescriptions = this.getApplicableChainDescriptionsFromExtensions();
        if (this.showSLOonly) {
            Iterator<ChainDescription> iter = chainDescriptions.iterator();
            ArrayList<ChainDescription> chainDescriptionsToRemove = new ArrayList<ChainDescription>();
            while (iter.hasNext()) {
                ChainDescription currentChainDescription = iter.next();
                if (currentChainDescription.getChainID().contains(SLO_VISUALIZATION_QUALITATIVE) || currentChainDescription.getChainID().contains(SLO_VISUALIZATION_QUANTITATVE)) continue;
                chainDescriptionsToRemove.add(currentChainDescription);
            }
            for (ChainDescription currentDescription : chainDescriptionsToRemove) {
                chainDescriptions.remove(currentDescription);
            }
        }
        return chainDescriptions;
    }

    private List<ChainDescription> getApplicableChainDescriptionsFromExtensions() {
        IConfigurationElement[] chainDescriptionExtensions;
        ArrayList<ChainDescription> result = new ArrayList<ChainDescription>();
        Map<String, AbstractVisualizationInput<?>> charts = this.getRegisteredVisualizations();
        IConfigurationElement[] iConfigurationElementArray = chainDescriptionExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(CHAIN_DESCRIPTION_EXTENSION_POINT_ID);
        int n = chainDescriptionExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            IPropertyConfigurable visualization = null;
            AbstractAdapter lastDataSource = null;
            boolean isApplicable = true;
            IConfigurationElement[] iConfigurationElementArray2 = e.getChildren();
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement child = iConfigurationElementArray2[n4];
                IPropertyConfigurable configurable = this.createAndConfigureChainElement(charts, child);
                if (child.getName().equals(ELEMENT_ID_DATASINK)) {
                    visualization = configurable;
                } else if (configurable instanceof AbstractAdapter) {
                    AbstractAdapter adapter = (AbstractAdapter)configurable;
                    if (!this.selectedSource.isCompatibleWith(adapter.getMetricDesciption())) {
                        isApplicable = false;
                        break;
                    }
                    if (lastDataSource != null) {
                        adapter.setDataSource((IDataSource)lastDataSource);
                    }
                    lastDataSource = adapter;
                }
                ++n4;
            }
            if (isApplicable) {
                ChainDescription newChainDescription = new ChainDescription(e.getAttribute(ID_ATTRIBUTE), e.getAttribute(NAME_ATTRIBUTE), lastDataSource, visualization);
                result.add(newChainDescription);
            }
            ++n2;
        }
        return result;
    }

    private IPropertyConfigurable createAndConfigureChainElement(Map<String, AbstractVisualizationInput<?>> charts, IConfigurationElement element) {
        IPropertyConfigurable configurable = this.createChainElement(charts, element);
        HashMap<String, String> elementProperties = new HashMap<String, String>(configurable.getProperties());
        IConfigurationElement[] iConfigurationElementArray = element.getChildren(ELEMENT_ID_PROPERTY);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement property = iConfigurationElementArray[n2];
            elementProperties.put(property.getAttribute(PROPERTY_KEY_ATTRIBUTE), property.getAttribute(PROPERTY_VALUE_ATTRIBUTE));
            ++n2;
        }
        configurable.setProperties(elementProperties);
        return configurable;
    }

    private IPropertyConfigurable createChainElement(Map<String, AbstractVisualizationInput<?>> charts, IConfigurationElement element) {
        try {
            if (element.getName().equals(ELEMENT_ID_DATASINK)) {
                return (IPropertyConfigurable)charts.get(element.getAttribute(DATASINK_ID_ATTRIBUTE));
            }
            if (element.getName().equals(ELEMENT_ID_FILTER)) {
                return (IPropertyConfigurable)element.createExecutableExtension(FILTER_CLASS_ATTRIBUTE);
            }
        }
        catch (CoreException e1) {
            LOGGER.log(Level.SEVERE, "Error in creating an Object referenced in an extension.");
            LOGGER.log(Level.SEVERE, e1.getMessage());
            throw new RuntimeException(e1.getMessage());
        }
        throw new IllegalArgumentException("Configuration element found which is not supported");
    }

    private Map<String, AbstractVisualizationInput<?>> getRegisteredVisualizations() {
        IConfigurationElement[] visualizationExtensions;
        HashMap result = new HashMap();
        IConfigurationElement[] iConfigurationElementArray = visualizationExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(DATASINK_EXTENSION_POINT_ID);
        int n = visualizationExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                String id = e.getAttribute(ID_ATTRIBUTE);
                AbstractVisualizationInput visualization = (AbstractVisualizationInput)e.createExecutableExtension(CLASS_ATTRIBUTE);
                result.put(id, visualization);
            }
            catch (CoreException e1) {
                LOGGER.log(Level.SEVERE, "Error in creating a Visualization referenced in an extension: Respective Id is " + e.getAttribute(ID_ATTRIBUTE) + ".");
                LOGGER.log(Level.SEVERE, e1.getMessage());
                throw new RuntimeException();
            }
            ++n2;
        }
        return result;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionStatus = this.statusOK;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.isEmpty()) {
            this.selectionStatus = new Status(4, "not_used", 0, "Please select a Visualization to proceed.", null);
        } else {
            int index = this.choiceViewer.getTable().getSelectionIndex();
            this.selectedDescription = this.applicableSequences.get(index);
            this.setSelectedDefault(this.selectedDescription);
            this.selectionStatus = this.statusOK;
        }
        this.updatePageStatus();
    }

    public IStatus updatePageStatus() {
        Status pageStatus = this.statusOK;
        ((SLOViewsWizard)this.getWizard()).setFinishable(false);
        switch (this.selectionStatus.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(this.selectionStatus.getMessage());
                pageStatus = this.statusOK;
                if (!this.selectedDescription.getChainID().contains(SLO_VISUALIZATION_QUALITATIVE) && !this.selectedDescription.getChainID().contains(SLO_VISUALIZATION_QUANTITATVE)) {
                    ((SLOViewsWizard)this.getWizard()).setFinishable(true);
                    break;
                }
                this.setPageComplete(true);
                ((SLOViewsWizard)this.getWizard()).setFinishable(false);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(this.selectionStatus.getMessage(), 2);
                pageStatus = this.selectionStatus;
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(this.selectionStatus.getMessage(), 1);
                pageStatus = this.selectionStatus;
                break;
            }
            default: {
                this.setErrorMessage(this.selectionStatus.getMessage());
                this.setMessage(null);
                pageStatus = this.selectionStatus;
            }
        }
        this.getContainer().updateButtons();
        return pageStatus;
    }

    public void setSelectedDefault(ChainDescription selection) {
        ((SLOViewsWizard)this.getWizard()).setSelectedDefault(selection);
    }

    public void initializePage(IDataSource selectedSource, boolean showSLOonly) {
        this.selectedSource = selectedSource;
        this.showSLOonly = showSLOonly;
        this.applicableSequences = this.getApplicableSequences();
        this.initializeChoiceViewer();
    }

    public void setShowSLOonly(boolean showSLOonly) {
        this.showSLOonly = showSLOonly;
        this.initializeChoiceViewer();
    }
}

