/**
 * Copyright 2006, SDQ Group, University Karlsruhe (TH)
 */
package org.palladiosimulator.solver.context.computed_usage.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.palladiosimulator.solver.context.computed_usage.util.ComputedUsageAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers. The
 * adapters generated by this factory convert EMF adapter notifications into calls to
 * {@link #fireNotifyChanged fireNotifyChanged}. The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances. <!-- begin-user-doc --> <!--
 * end-user-doc -->
 *
 * @generated
 */
public class ComputedUsageItemProviderAdapterFactory extends ComputedUsageAdapterFactory
        implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    public static final String copyright = "Copyright 2006, SDQ Group, University Karlsruhe (TH)";

    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType
     * isFactoryForType}. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object>();

    /**
     * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    public ComputedUsageItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.solver.context.computed_usage.ComputedUsageContext} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ComputedUsageContextItemProvider computedUsageContextItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.solver.context.computed_usage.ComputedUsageContext}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createComputedUsageContextAdapter() {
        if (this.computedUsageContextItemProvider == null)
        {
            this.computedUsageContextItemProvider = new ComputedUsageContextItemProvider(this);
        }

        return this.computedUsageContextItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.solver.context.computed_usage.BranchProbability} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected BranchProbabilityItemProvider branchProbabilityItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.solver.context.computed_usage.BranchProbability}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createBranchProbabilityAdapter() {
        if (this.branchProbabilityItemProvider == null)
        {
            this.branchProbabilityItemProvider = new BranchProbabilityItemProvider(this);
        }

        return this.branchProbabilityItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.solver.context.computed_usage.LoopIteration} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected LoopIterationItemProvider loopIterationItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.solver.context.computed_usage.LoopIteration}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createLoopIterationAdapter() {
        if (this.loopIterationItemProvider == null)
        {
            this.loopIterationItemProvider = new LoopIterationItemProvider(this);
        }

        return this.loopIterationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.solver.context.computed_usage.Input} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected InputItemProvider inputItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.solver.context.computed_usage.Input}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createInputAdapter() {
        if (this.inputItemProvider == null)
        {
            this.inputItemProvider = new InputItemProvider(this);
        }

        return this.inputItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.solver.context.computed_usage.ExternalCallOutput} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ExternalCallOutputItemProvider externalCallOutputItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.solver.context.computed_usage.ExternalCallOutput}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createExternalCallOutputAdapter() {
        if (this.externalCallOutputItemProvider == null)
        {
            this.externalCallOutputItemProvider = new ExternalCallOutputItemProvider(this);
        }

        return this.externalCallOutputItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.solver.context.computed_usage.ExternalCallInput} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ExternalCallInputItemProvider externalCallInputItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.solver.context.computed_usage.ExternalCallInput}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createExternalCallInputAdapter() {
        if (this.externalCallInputItemProvider == null)
        {
            this.externalCallInputItemProvider = new ExternalCallInputItemProvider(this);
        }

        return this.externalCallInputItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.solver.context.computed_usage.Output} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected OutputItemProvider outputItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.solver.context.computed_usage.Output}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createOutputAdapter() {
        if (this.outputItemProvider == null)
        {
            this.outputItemProvider = new OutputItemProvider(this);
        }

        return this.outputItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.solver.context.computed_usage.ComputedUsage} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ComputedUsageItemProvider computedUsageItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.solver.context.computed_usage.ComputedUsage}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createComputedUsageAdapter() {
        if (this.computedUsageItemProvider == null)
        {
            this.computedUsageItemProvider = new ComputedUsageItemProvider(this);
        }

        return this.computedUsageItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void setParentAdapterFactory(final ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public boolean isFactoryForType(final Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter adapt(final Notifier notifier, final Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Object adapt(final Object object, final Object type) {
        if (this.isFactoryForType(type))
        {
            final Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter)))
            {
                return adapter;
            }
        }

        return null;
    }

    /**
     * This adds a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void addListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void removeListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void fireNotifyChanged(final Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);

        if (this.parentAdapterFactory != null)
        {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    /**
     * This disposes all of the item providers created by this factory. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    @Override
    public void dispose() {
        if (this.computedUsageContextItemProvider != null) {
            this.computedUsageContextItemProvider.dispose();
        }
        if (this.branchProbabilityItemProvider != null) {
            this.branchProbabilityItemProvider.dispose();
        }
        if (this.loopIterationItemProvider != null) {
            this.loopIterationItemProvider.dispose();
        }
        if (this.inputItemProvider != null) {
            this.inputItemProvider.dispose();
        }
        if (this.externalCallOutputItemProvider != null) {
            this.externalCallOutputItemProvider.dispose();
        }
        if (this.externalCallInputItemProvider != null) {
            this.externalCallInputItemProvider.dispose();
        }
        if (this.outputItemProvider != null) {
            this.outputItemProvider.dispose();
        }
        if (this.computedUsageItemProvider != null) {
            this.computedUsageItemProvider.dispose();
        }
    }

}
