/**
 */
package org.palladiosimulator.solver.lqn.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.palladiosimulator.solver.lqn.util.LqnAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc --> <!--
 * end-user-doc -->
 * @generated
 */
public class LqnItemProviderAdapterFactory extends LqnAdapterFactory implements
		ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public LqnItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.ActivityDefBase} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ActivityDefBaseItemProvider activityDefBaseItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.ActivityDefBase}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createActivityDefBaseAdapter() {
		if (activityDefBaseItemProvider == null) {
			activityDefBaseItemProvider = new ActivityDefBaseItemProvider(this);
		}

		return activityDefBaseItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.ActivityDefType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ActivityDefTypeItemProvider activityDefTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.ActivityDefType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createActivityDefTypeAdapter() {
		if (activityDefTypeItemProvider == null) {
			activityDefTypeItemProvider = new ActivityDefTypeItemProvider(this);
		}

		return activityDefTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.ActivityGraphBase} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ActivityGraphBaseItemProvider activityGraphBaseItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.ActivityGraphBase}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createActivityGraphBaseAdapter() {
		if (activityGraphBaseItemProvider == null) {
			activityGraphBaseItemProvider = new ActivityGraphBaseItemProvider(
					this);
		}

		return activityGraphBaseItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.ActivityListType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ActivityListTypeItemProvider activityListTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.ActivityListType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createActivityListTypeAdapter() {
		if (activityListTypeItemProvider == null) {
			activityListTypeItemProvider = new ActivityListTypeItemProvider(
					this);
		}

		return activityListTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.ActivityLoopListType} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ActivityLoopListTypeItemProvider activityLoopListTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.ActivityLoopListType}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createActivityLoopListTypeAdapter() {
		if (activityLoopListTypeItemProvider == null) {
			activityLoopListTypeItemProvider = new ActivityLoopListTypeItemProvider(
					this);
		}

		return activityLoopListTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.ActivityLoopType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ActivityLoopTypeItemProvider activityLoopTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.ActivityLoopType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createActivityLoopTypeAdapter() {
		if (activityLoopTypeItemProvider == null) {
			activityLoopTypeItemProvider = new ActivityLoopTypeItemProvider(
					this);
		}

		return activityLoopTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.palladiosimulator.solver.lqn.ActivityMakingCallType} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected ActivityMakingCallTypeItemProvider activityMakingCallTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.ActivityMakingCallType}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createActivityMakingCallTypeAdapter() {
		if (activityMakingCallTypeItemProvider == null) {
			activityMakingCallTypeItemProvider = new ActivityMakingCallTypeItemProvider(
					this);
		}

		return activityMakingCallTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.ActivityOrType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ActivityOrTypeItemProvider activityOrTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.ActivityOrType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createActivityOrTypeAdapter() {
		if (activityOrTypeItemProvider == null) {
			activityOrTypeItemProvider = new ActivityOrTypeItemProvider(this);
		}

		return activityOrTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.ActivityPhasesType} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ActivityPhasesTypeItemProvider activityPhasesTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.ActivityPhasesType}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createActivityPhasesTypeAdapter() {
		if (activityPhasesTypeItemProvider == null) {
			activityPhasesTypeItemProvider = new ActivityPhasesTypeItemProvider(
					this);
		}

		return activityPhasesTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.ActivityType} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected ActivityTypeItemProvider activityTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.ActivityType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createActivityTypeAdapter() {
		if (activityTypeItemProvider == null) {
			activityTypeItemProvider = new ActivityTypeItemProvider(this);
		}

		return activityTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.AndJoinListType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AndJoinListTypeItemProvider andJoinListTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.AndJoinListType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createAndJoinListTypeAdapter() {
		if (andJoinListTypeItemProvider == null) {
			andJoinListTypeItemProvider = new AndJoinListTypeItemProvider(this);
		}

		return andJoinListTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.AsynchCallType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AsynchCallTypeItemProvider asynchCallTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.AsynchCallType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createAsynchCallTypeAdapter() {
		if (asynchCallTypeItemProvider == null) {
			asynchCallTypeItemProvider = new AsynchCallTypeItemProvider(this);
		}

		return asynchCallTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.BindType} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected BindTypeItemProvider bindTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.BindType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createBindTypeAdapter() {
		if (bindTypeItemProvider == null) {
			bindTypeItemProvider = new BindTypeItemProvider(this);
		}

		return bindTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.CallListType} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected CallListTypeItemProvider callListTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.CallListType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createCallListTypeAdapter() {
		if (callListTypeItemProvider == null) {
			callListTypeItemProvider = new CallListTypeItemProvider(this);
		}

		return callListTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.DocumentRoot} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected DocumentRootItemProvider documentRootItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.DocumentRoot}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createDocumentRootAdapter() {
		if (documentRootItemProvider == null) {
			documentRootItemProvider = new DocumentRootItemProvider(this);
		}

		return documentRootItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.EntryActivityDefType} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected EntryActivityDefTypeItemProvider entryActivityDefTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.EntryActivityDefType}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEntryActivityDefTypeAdapter() {
		if (entryActivityDefTypeItemProvider == null) {
			entryActivityDefTypeItemProvider = new EntryActivityDefTypeItemProvider(
					this);
		}

		return entryActivityDefTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.EntryActivityGraph} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected EntryActivityGraphItemProvider entryActivityGraphItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.EntryActivityGraph}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEntryActivityGraphAdapter() {
		if (entryActivityGraphItemProvider == null) {
			entryActivityGraphItemProvider = new EntryActivityGraphItemProvider(
					this);
		}

		return entryActivityGraphItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.EntryMakingCallType} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected EntryMakingCallTypeItemProvider entryMakingCallTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.EntryMakingCallType}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEntryMakingCallTypeAdapter() {
		if (entryMakingCallTypeItemProvider == null) {
			entryMakingCallTypeItemProvider = new EntryMakingCallTypeItemProvider(
					this);
		}

		return entryMakingCallTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.EntryType} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected EntryTypeItemProvider entryTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.EntryType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createEntryTypeAdapter() {
		if (entryTypeItemProvider == null) {
			entryTypeItemProvider = new EntryTypeItemProvider(this);
		}

		return entryTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.FanInType} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected FanInTypeItemProvider fanInTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.FanInType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createFanInTypeAdapter() {
		if (fanInTypeItemProvider == null) {
			fanInTypeItemProvider = new FanInTypeItemProvider(this);
		}

		return fanInTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.FanOutType} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected FanOutTypeItemProvider fanOutTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.FanOutType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createFanOutTypeAdapter() {
		if (fanOutTypeItemProvider == null) {
			fanOutTypeItemProvider = new FanOutTypeItemProvider(this);
		}

		return fanOutTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.FirstPlotType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FirstPlotTypeItemProvider firstPlotTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.FirstPlotType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createFirstPlotTypeAdapter() {
		if (firstPlotTypeItemProvider == null) {
			firstPlotTypeItemProvider = new FirstPlotTypeItemProvider(this);
		}

		return firstPlotTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.GroupType} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected GroupTypeItemProvider groupTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.GroupType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createGroupTypeAdapter() {
		if (groupTypeItemProvider == null) {
			groupTypeItemProvider = new GroupTypeItemProvider(this);
		}

		return groupTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.HistogramBinType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HistogramBinTypeItemProvider histogramBinTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.HistogramBinType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createHistogramBinTypeAdapter() {
		if (histogramBinTypeItemProvider == null) {
			histogramBinTypeItemProvider = new HistogramBinTypeItemProvider(
					this);
		}

		return histogramBinTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.InPortType} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected InPortTypeItemProvider inPortTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.InPortType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createInPortTypeAdapter() {
		if (inPortTypeItemProvider == null) {
			inPortTypeItemProvider = new InPortTypeItemProvider(this);
		}

		return inPortTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.InterfaceType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InterfaceTypeItemProvider interfaceTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.InterfaceType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createInterfaceTypeAdapter() {
		if (interfaceTypeItemProvider == null) {
			interfaceTypeItemProvider = new InterfaceTypeItemProvider(this);
		}

		return interfaceTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.LqnCoreType} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected LqnCoreTypeItemProvider lqnCoreTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.LqnCoreType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createLqnCoreTypeAdapter() {
		if (lqnCoreTypeItemProvider == null) {
			lqnCoreTypeItemProvider = new LqnCoreTypeItemProvider(this);
		}

		return lqnCoreTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.LqnModelType} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected LqnModelTypeItemProvider lqnModelTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.LqnModelType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createLqnModelTypeAdapter() {
		if (lqnModelTypeItemProvider == null) {
			lqnModelTypeItemProvider = new LqnModelTypeItemProvider(this);
		}

		return lqnModelTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.MakingCallType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MakingCallTypeItemProvider makingCallTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.MakingCallType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createMakingCallTypeAdapter() {
		if (makingCallTypeItemProvider == null) {
			makingCallTypeItemProvider = new MakingCallTypeItemProvider(this);
		}

		return makingCallTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.MvaInfoType} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected MvaInfoTypeItemProvider mvaInfoTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.MvaInfoType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createMvaInfoTypeAdapter() {
		if (mvaInfoTypeItemProvider == null) {
			mvaInfoTypeItemProvider = new MvaInfoTypeItemProvider(this);
		}

		return mvaInfoTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.OrListType} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected OrListTypeItemProvider orListTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.OrListType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createOrListTypeAdapter() {
		if (orListTypeItemProvider == null) {
			orListTypeItemProvider = new OrListTypeItemProvider(this);
		}

		return orListTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.OutPortType} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected OutPortTypeItemProvider outPortTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.OutPortType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createOutPortTypeAdapter() {
		if (outPortTypeItemProvider == null) {
			outPortTypeItemProvider = new OutPortTypeItemProvider(this);
		}

		return outPortTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.palladiosimulator.solver.lqn.OutputDistributionType} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected OutputDistributionTypeItemProvider outputDistributionTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.OutputDistributionType}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOutputDistributionTypeAdapter() {
		if (outputDistributionTypeItemProvider == null) {
			outputDistributionTypeItemProvider = new OutputDistributionTypeItemProvider(
					this);
		}

		return outputDistributionTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.palladiosimulator.solver.lqn.OutputEntryDistributionType} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected OutputEntryDistributionTypeItemProvider outputEntryDistributionTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.OutputEntryDistributionType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOutputEntryDistributionTypeAdapter() {
		if (outputEntryDistributionTypeItemProvider == null) {
			outputEntryDistributionTypeItemProvider = new OutputEntryDistributionTypeItemProvider(
					this);
		}

		return outputEntryDistributionTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.palladiosimulator.solver.lqn.OutputResultJoinDelayType} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected OutputResultJoinDelayTypeItemProvider outputResultJoinDelayTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.OutputResultJoinDelayType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOutputResultJoinDelayTypeAdapter() {
		if (outputResultJoinDelayTypeItemProvider == null) {
			outputResultJoinDelayTypeItemProvider = new OutputResultJoinDelayTypeItemProvider(
					this);
		}

		return outputResultJoinDelayTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.OutputResultType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OutputResultTypeItemProvider outputResultTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.OutputResultType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createOutputResultTypeAdapter() {
		if (outputResultTypeItemProvider == null) {
			outputResultTypeItemProvider = new OutputResultTypeItemProvider(
					this);
		}

		return outputResultTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.ParameterType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ParameterTypeItemProvider parameterTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.ParameterType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createParameterTypeAdapter() {
		if (parameterTypeItemProvider == null) {
			parameterTypeItemProvider = new ParameterTypeItemProvider(this);
		}

		return parameterTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.ParaType} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected ParaTypeItemProvider paraTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.ParaType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createParaTypeAdapter() {
		if (paraTypeItemProvider == null) {
			paraTypeItemProvider = new ParaTypeItemProvider(this);
		}

		return paraTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.PhaseActivities} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PhaseActivitiesItemProvider phaseActivitiesItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.PhaseActivities}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createPhaseActivitiesAdapter() {
		if (phaseActivitiesItemProvider == null) {
			phaseActivitiesItemProvider = new PhaseActivitiesItemProvider(this);
		}

		return phaseActivitiesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.PlotControlType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PlotControlTypeItemProvider plotControlTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.PlotControlType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createPlotControlTypeAdapter() {
		if (plotControlTypeItemProvider == null) {
			plotControlTypeItemProvider = new PlotControlTypeItemProvider(this);
		}

		return plotControlTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.PlotType} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected PlotTypeItemProvider plotTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.PlotType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createPlotTypeAdapter() {
		if (plotTypeItemProvider == null) {
			plotTypeItemProvider = new PlotTypeItemProvider(this);
		}

		return plotTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.PortBindingType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PortBindingTypeItemProvider portBindingTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.PortBindingType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createPortBindingTypeAdapter() {
		if (portBindingTypeItemProvider == null) {
			portBindingTypeItemProvider = new PortBindingTypeItemProvider(this);
		}

		return portBindingTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.PragmaType} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected PragmaTypeItemProvider pragmaTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.PragmaType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createPragmaTypeAdapter() {
		if (pragmaTypeItemProvider == null) {
			pragmaTypeItemProvider = new PragmaTypeItemProvider(this);
		}

		return pragmaTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.PrecedenceType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PrecedenceTypeItemProvider precedenceTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.PrecedenceType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createPrecedenceTypeAdapter() {
		if (precedenceTypeItemProvider == null) {
			precedenceTypeItemProvider = new PrecedenceTypeItemProvider(this);
		}

		return precedenceTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.ProcessorBindingType} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessorBindingTypeItemProvider processorBindingTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.ProcessorBindingType}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessorBindingTypeAdapter() {
		if (processorBindingTypeItemProvider == null) {
			processorBindingTypeItemProvider = new ProcessorBindingTypeItemProvider(
					this);
		}

		return processorBindingTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.ProcessorType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessorTypeItemProvider processorTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.ProcessorType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createProcessorTypeAdapter() {
		if (processorTypeItemProvider == null) {
			processorTypeItemProvider = new ProcessorTypeItemProvider(this);
		}

		return processorTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.ReplyActivityType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReplyActivityTypeItemProvider replyActivityTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.ReplyActivityType}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReplyActivityTypeAdapter() {
		if (replyActivityTypeItemProvider == null) {
			replyActivityTypeItemProvider = new ReplyActivityTypeItemProvider(
					this);
		}

		return replyActivityTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.ReplyEntryType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReplyEntryTypeItemProvider replyEntryTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.ReplyEntryType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createReplyEntryTypeAdapter() {
		if (replyEntryTypeItemProvider == null) {
			replyEntryTypeItemProvider = new ReplyEntryTypeItemProvider(this);
		}

		return replyEntryTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.ResultConf95Type} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ResultConf95TypeItemProvider resultConf95TypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.ResultConf95Type}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createResultConf95TypeAdapter() {
		if (resultConf95TypeItemProvider == null) {
			resultConf95TypeItemProvider = new ResultConf95TypeItemProvider(
					this);
		}

		return resultConf95TypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.ResultConf95Type1} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ResultConf95Type1ItemProvider resultConf95Type1ItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.ResultConf95Type1}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createResultConf95Type1Adapter() {
		if (resultConf95Type1ItemProvider == null) {
			resultConf95Type1ItemProvider = new ResultConf95Type1ItemProvider(
					this);
		}

		return resultConf95Type1ItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.ResultConf99Type} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ResultConf99TypeItemProvider resultConf99TypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.ResultConf99Type}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createResultConf99TypeAdapter() {
		if (resultConf99TypeItemProvider == null) {
			resultConf99TypeItemProvider = new ResultConf99TypeItemProvider(
					this);
		}

		return resultConf99TypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.ResultConf99Type1} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ResultConf99Type1ItemProvider resultConf99Type1ItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.ResultConf99Type1}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createResultConf99Type1Adapter() {
		if (resultConf99Type1ItemProvider == null) {
			resultConf99Type1ItemProvider = new ResultConf99Type1ItemProvider(
					this);
		}

		return resultConf99Type1ItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.ResultGeneralType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ResultGeneralTypeItemProvider resultGeneralTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.ResultGeneralType}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createResultGeneralTypeAdapter() {
		if (resultGeneralTypeItemProvider == null) {
			resultGeneralTypeItemProvider = new ResultGeneralTypeItemProvider(
					this);
		}

		return resultGeneralTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.RunControlType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunControlTypeItemProvider runControlTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.RunControlType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createRunControlTypeAdapter() {
		if (runControlTypeItemProvider == null) {
			runControlTypeItemProvider = new RunControlTypeItemProvider(this);
		}

		return runControlTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.ServiceType} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected ServiceTypeItemProvider serviceTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.ServiceType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createServiceTypeAdapter() {
		if (serviceTypeItemProvider == null) {
			serviceTypeItemProvider = new ServiceTypeItemProvider(this);
		}

		return serviceTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.palladiosimulator.solver.lqn.SingleActivityListType} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected SingleActivityListTypeItemProvider singleActivityListTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.SingleActivityListType}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSingleActivityListTypeAdapter() {
		if (singleActivityListTypeItemProvider == null) {
			singleActivityListTypeItemProvider = new SingleActivityListTypeItemProvider(
					this);
		}

		return singleActivityListTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.SlotType} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected SlotTypeItemProvider slotTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.SlotType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createSlotTypeAdapter() {
		if (slotTypeItemProvider == null) {
			slotTypeItemProvider = new SlotTypeItemProvider(this);
		}

		return slotTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.SolverParamsType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SolverParamsTypeItemProvider solverParamsTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.SolverParamsType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createSolverParamsTypeAdapter() {
		if (solverParamsTypeItemProvider == null) {
			solverParamsTypeItemProvider = new SolverParamsTypeItemProvider(
					this);
		}

		return solverParamsTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.SynchCallType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SynchCallTypeItemProvider synchCallTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.SynchCallType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createSynchCallTypeAdapter() {
		if (synchCallTypeItemProvider == null) {
			synchCallTypeItemProvider = new SynchCallTypeItemProvider(this);
		}

		return synchCallTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.TaskActivityGraph} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TaskActivityGraphItemProvider taskActivityGraphItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.TaskActivityGraph}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTaskActivityGraphAdapter() {
		if (taskActivityGraphItemProvider == null) {
			taskActivityGraphItemProvider = new TaskActivityGraphItemProvider(
					this);
		}

		return taskActivityGraphItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.solver.lqn.TaskType} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected TaskTypeItemProvider taskTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.solver.lqn.TaskType}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createTaskTypeAdapter() {
		if (taskTypeItemProvider == null) {
			taskTypeItemProvider = new TaskTypeItemProvider(this);
		}

		return taskTypeItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory
				.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(
			ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>)
					|| (((Class<?>) type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (activityDefBaseItemProvider != null)
			activityDefBaseItemProvider.dispose();
		if (activityDefTypeItemProvider != null)
			activityDefTypeItemProvider.dispose();
		if (activityGraphBaseItemProvider != null)
			activityGraphBaseItemProvider.dispose();
		if (activityListTypeItemProvider != null)
			activityListTypeItemProvider.dispose();
		if (activityLoopListTypeItemProvider != null)
			activityLoopListTypeItemProvider.dispose();
		if (activityLoopTypeItemProvider != null)
			activityLoopTypeItemProvider.dispose();
		if (activityMakingCallTypeItemProvider != null)
			activityMakingCallTypeItemProvider.dispose();
		if (activityOrTypeItemProvider != null)
			activityOrTypeItemProvider.dispose();
		if (activityPhasesTypeItemProvider != null)
			activityPhasesTypeItemProvider.dispose();
		if (activityTypeItemProvider != null)
			activityTypeItemProvider.dispose();
		if (andJoinListTypeItemProvider != null)
			andJoinListTypeItemProvider.dispose();
		if (asynchCallTypeItemProvider != null)
			asynchCallTypeItemProvider.dispose();
		if (bindTypeItemProvider != null)
			bindTypeItemProvider.dispose();
		if (callListTypeItemProvider != null)
			callListTypeItemProvider.dispose();
		if (documentRootItemProvider != null)
			documentRootItemProvider.dispose();
		if (entryActivityDefTypeItemProvider != null)
			entryActivityDefTypeItemProvider.dispose();
		if (entryActivityGraphItemProvider != null)
			entryActivityGraphItemProvider.dispose();
		if (entryMakingCallTypeItemProvider != null)
			entryMakingCallTypeItemProvider.dispose();
		if (entryTypeItemProvider != null)
			entryTypeItemProvider.dispose();
		if (fanInTypeItemProvider != null)
			fanInTypeItemProvider.dispose();
		if (fanOutTypeItemProvider != null)
			fanOutTypeItemProvider.dispose();
		if (firstPlotTypeItemProvider != null)
			firstPlotTypeItemProvider.dispose();
		if (groupTypeItemProvider != null)
			groupTypeItemProvider.dispose();
		if (histogramBinTypeItemProvider != null)
			histogramBinTypeItemProvider.dispose();
		if (inPortTypeItemProvider != null)
			inPortTypeItemProvider.dispose();
		if (interfaceTypeItemProvider != null)
			interfaceTypeItemProvider.dispose();
		if (lqnCoreTypeItemProvider != null)
			lqnCoreTypeItemProvider.dispose();
		if (lqnModelTypeItemProvider != null)
			lqnModelTypeItemProvider.dispose();
		if (makingCallTypeItemProvider != null)
			makingCallTypeItemProvider.dispose();
		if (mvaInfoTypeItemProvider != null)
			mvaInfoTypeItemProvider.dispose();
		if (orListTypeItemProvider != null)
			orListTypeItemProvider.dispose();
		if (outPortTypeItemProvider != null)
			outPortTypeItemProvider.dispose();
		if (outputDistributionTypeItemProvider != null)
			outputDistributionTypeItemProvider.dispose();
		if (outputEntryDistributionTypeItemProvider != null)
			outputEntryDistributionTypeItemProvider.dispose();
		if (outputResultJoinDelayTypeItemProvider != null)
			outputResultJoinDelayTypeItemProvider.dispose();
		if (outputResultTypeItemProvider != null)
			outputResultTypeItemProvider.dispose();
		if (parameterTypeItemProvider != null)
			parameterTypeItemProvider.dispose();
		if (paraTypeItemProvider != null)
			paraTypeItemProvider.dispose();
		if (phaseActivitiesItemProvider != null)
			phaseActivitiesItemProvider.dispose();
		if (plotControlTypeItemProvider != null)
			plotControlTypeItemProvider.dispose();
		if (plotTypeItemProvider != null)
			plotTypeItemProvider.dispose();
		if (portBindingTypeItemProvider != null)
			portBindingTypeItemProvider.dispose();
		if (pragmaTypeItemProvider != null)
			pragmaTypeItemProvider.dispose();
		if (precedenceTypeItemProvider != null)
			precedenceTypeItemProvider.dispose();
		if (processorBindingTypeItemProvider != null)
			processorBindingTypeItemProvider.dispose();
		if (processorTypeItemProvider != null)
			processorTypeItemProvider.dispose();
		if (replyActivityTypeItemProvider != null)
			replyActivityTypeItemProvider.dispose();
		if (replyEntryTypeItemProvider != null)
			replyEntryTypeItemProvider.dispose();
		if (resultConf95TypeItemProvider != null)
			resultConf95TypeItemProvider.dispose();
		if (resultConf95Type1ItemProvider != null)
			resultConf95Type1ItemProvider.dispose();
		if (resultConf99TypeItemProvider != null)
			resultConf99TypeItemProvider.dispose();
		if (resultConf99Type1ItemProvider != null)
			resultConf99Type1ItemProvider.dispose();
		if (resultGeneralTypeItemProvider != null)
			resultGeneralTypeItemProvider.dispose();
		if (runControlTypeItemProvider != null)
			runControlTypeItemProvider.dispose();
		if (serviceTypeItemProvider != null)
			serviceTypeItemProvider.dispose();
		if (singleActivityListTypeItemProvider != null)
			singleActivityListTypeItemProvider.dispose();
		if (slotTypeItemProvider != null)
			slotTypeItemProvider.dispose();
		if (solverParamsTypeItemProvider != null)
			solverParamsTypeItemProvider.dispose();
		if (synchCallTypeItemProvider != null)
			synchCallTypeItemProvider.dispose();
		if (taskActivityGraphItemProvider != null)
			taskActivityGraphItemProvider.dispose();
		if (taskTypeItemProvider != null)
			taskTypeItemProvider.dispose();
	}

}
