/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.reliability;

public class Inverse {
    public static void gaussian(double[][] a, int[] index) {
        int n = index.length;
        double[] c = new double[n];
        int i = 0;
        while (i < n) {
            index[i] = i;
            ++i;
        }
        i = 0;
        while (i < n) {
            double c1 = 0.0;
            int j = 0;
            while (j < n) {
                double c0 = Math.abs(a[i][j]);
                if (c0 > c1) {
                    c1 = c0;
                }
                ++j;
            }
            c[i] = c1;
            ++i;
        }
        int k = 0;
        int j = 0;
        while (j < n - 1) {
            double pi1 = 0.0;
            int i2 = j;
            while (i2 < n) {
                double pi0 = Math.abs(a[index[i2]][j]);
                if ((pi0 /= c[index[i2]]) > pi1) {
                    pi1 = pi0;
                    k = i2;
                }
                ++i2;
            }
            int itmp = index[j];
            index[j] = index[k];
            index[k] = itmp;
            int i3 = j + 1;
            while (i3 < n) {
                double pj;
                a[index[i3]][j] = pj = a[index[i3]][j] / a[index[j]][j];
                int l = j + 1;
                while (l < n) {
                    double[] dArray = a[index[i3]];
                    int n2 = l;
                    dArray[n2] = dArray[n2] - pj * a[index[j]][l];
                    ++l;
                }
                ++i3;
            }
            ++j;
        }
    }

    public static double[][] invert(double[][] a) {
        int k;
        int j;
        int n = a.length;
        double[][] x = new double[n][n];
        double[][] b = new double[n][n];
        int[] index = new int[n];
        int i = 0;
        while (i < n) {
            b[i][i] = 1.0;
            ++i;
        }
        Inverse.gaussian(a, index);
        i = 0;
        while (i < n - 1) {
            j = i + 1;
            while (j < n) {
                k = 0;
                while (k < n) {
                    double[] dArray = b[index[j]];
                    int n2 = k;
                    dArray[n2] = dArray[n2] - a[index[j]][i] * b[index[i]][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            x[n - 1][i] = b[index[n - 1]][i] / a[index[n - 1]][n - 1];
            j = n - 2;
            while (j >= 0) {
                x[j][i] = b[index[j]][i];
                k = j + 1;
                while (k < n) {
                    double[] dArray = x[j];
                    int n3 = i;
                    dArray[n3] = dArray[n3] - a[index[j]][k] * x[k][i];
                    ++k;
                }
                double[] dArray = x[j];
                int n4 = i;
                dArray[n4] = dArray[n4] / a[index[j]][j];
                --j;
            }
            ++i;
        }
        return x;
    }
}

