/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.reliability.pcm2markov;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.reliability.MarkovEvaluationType;
import org.palladiosimulator.reliability.helper.MarkovFailureTypeHelper;
import org.palladiosimulator.reliability.markov.MarkovChain;
import org.palladiosimulator.solver.models.PCMInstance;
import org.palladiosimulator.solver.reliability.MarkovSolver;
import org.palladiosimulator.solver.reliability.pcm2markov.MarkovResourceState;
import org.palladiosimulator.solver.reliability.pcm2markov.MarkovTransformationResult;
import org.palladiosimulator.solver.reliability.pcm2markov.MarkovTransformationSource;
import org.palladiosimulator.solver.reliability.pcm2markov.MarkovUsageModelVisitor;
import org.palladiosimulator.solver.reliability.pcm2markov.ProcessingResourceDescriptor;
import org.palladiosimulator.solver.reliability.sensitivity.MarkovSensitivity;
import org.palladiosimulator.solver.runconfig.PCMSolverWorkflowRunConfiguration;
import org.palladiosimulator.solver.visitors.UsageModelVisitor;

public class MarkovTransformation {
    private static final Logger LOGGER = Logger.getLogger((String)MarkovTransformation.class.getName());
    private final MarkovFailureTypeHelper helper = new MarkovFailureTypeHelper();

    private boolean createNextPermutation(List<ProcessingResourceDescriptor> descriptors) {
        int size = descriptors.size();
        int k = -1;
        int i = 0;
        while (i < size - 1) {
            if (descriptors.get(i).getCurrentState() == MarkovResourceState.NA && descriptors.get(i + 1).getCurrentState() == MarkovResourceState.OK) {
                k = i;
            }
            ++i;
        }
        if (k == -1) {
            return false;
        }
        int l = k + 1;
        i = k + 2;
        while (i < size) {
            if (descriptors.get(i).getCurrentState() == MarkovResourceState.OK) {
                l = i;
            }
            ++i;
        }
        descriptors.get(k).switchState();
        descriptors.get(l).switchState();
        int left = k + 1;
        int right = size - 1;
        while (left < right) {
            MarkovResourceState tmp = descriptors.get(left).getCurrentState();
            descriptors.get(left).setCurrentState(descriptors.get(right).getCurrentState());
            descriptors.get(right).setCurrentState(tmp);
            ++left;
            --right;
        }
        return true;
    }

    private MarkovEvaluationType getEvaluationMode(PCMSolverWorkflowRunConfiguration configuration) {
        return MarkovEvaluationType.valueOf((String)configuration.getMarkovEvaluationMode());
    }

    private void initializeResourceStates(List<ProcessingResourceDescriptor> descriptors, int m) {
        int size = descriptors.size();
        int i = 0;
        while (i < m) {
            descriptors.get(i).setCurrentState(MarkovResourceState.NA);
            ++i;
        }
        i = m;
        while (i < size) {
            descriptors.get(i).setCurrentState(MarkovResourceState.OK);
            ++i;
        }
    }

    private boolean isStopConditionReached(PCMSolverWorkflowRunConfiguration configuration, MarkovTransformationResult markovResult, long startTimeMs) {
        if (configuration.isSolvingTimeLimitEnabled() && System.currentTimeMillis() - startTimeMs >= configuration.getSolvingTimeLimit() * 1000L) {
            LOGGER.info((Object)("Maximal solving time (" + configuration.getSolvingTimeLimit() + " seconds) reached - stopping!"));
            return true;
        }
        if (configuration.isNumberOfEvaluatedSystemStatesEnabled() && markovResult.getPhysicalStateEvaluationCount() == configuration.getNumberOfEvaluatedSystemStates()) {
            LOGGER.info((Object)("Maximal number of evaluated system states (" + configuration.getNumberOfEvaluatedSystemStates() + ") reached - stopping!"));
            return true;
        }
        if (configuration.isNumberOfExactDecimalPlacesEnabled() && markovResult.hasRequiredAccuracy(configuration.getNumberOfExactDecimalPlaces())) {
            LOGGER.info((Object)("Required number of exact decimal places (" + configuration.getNumberOfExactDecimalPlaces() + ") reached - stopping!"));
            return true;
        }
        return false;
    }

    private void runDSolver(UsageScenario scenario, MarkovTransformationSource markovSource) {
        LOGGER.debug((Object)"Resolving parametric dependencies.");
        long startTime = System.nanoTime();
        UsageModelVisitor visitor = new UsageModelVisitor(markovSource.getModel());
        visitor.doSwitch((EObject)scenario.getScenarioBehaviour_UsageScenario());
        long stopTime = System.nanoTime();
        long duration = TimeUnit.NANOSECONDS.toMillis(stopTime - startTime);
        LOGGER.info((Object)("Solved parametric dependencies: " + duration + " ms"));
    }

    private boolean runPcm2Markov(PCMSolverWorkflowRunConfiguration configuration, UsageScenario scenario, MarkovTransformationSource markovSource, MarkovTransformationResult markovResult) {
        LOGGER.debug((Object)"Transforming PCM model into analysis model.");
        boolean approximate = false;
        long startTime = System.nanoTime();
        if (!configuration.isIterationOverPhysicalSystemStatesEnabled()) {
            this.runPcm2MarkovSingle(configuration, scenario, markovSource, markovResult);
        } else {
            approximate = this.runPcm2MarkovIteratively(configuration, scenario, markovSource, markovResult);
        }
        long stopTime = System.nanoTime();
        long duration = TimeUnit.NANOSECONDS.toMillis(stopTime - startTime);
        LOGGER.info((Object)("Finished Markov transformation: " + duration + " ms"));
        if (configuration.isIterationOverPhysicalSystemStatesEnabled()) {
            LOGGER.info((Object)("Number of evaluated physical system states: " + markovResult.getPhysicalStateEvaluationCount() + " out of " + markovResult.getNumberOfPhysicalSystemStates()));
        }
        return approximate;
    }

    private boolean runPcm2MarkovIteratively(PCMSolverWorkflowRunConfiguration configuration, UsageScenario scenario, MarkovTransformationSource markovSource, MarkovTransformationResult markovResult) {
        long startTimeMs = System.currentTimeMillis();
        List<ProcessingResourceDescriptor> descriptors = markovSource.getUnreliableResourceDescriptors();
        int size = descriptors.size();
        int permutationClass = 0;
        while (permutationClass <= size) {
            this.initializeResourceStates(descriptors, permutationClass);
            this.runPcm2MarkovSingle(configuration, scenario, markovSource, markovResult);
            if (this.isStopConditionReached(configuration, markovResult, startTimeMs)) {
                return true;
            }
            while (this.createNextPermutation(descriptors)) {
                this.runPcm2MarkovSingle(configuration, scenario, markovSource, markovResult);
                if (!this.isStopConditionReached(configuration, markovResult, startTimeMs)) continue;
                return true;
            }
            ++permutationClass;
        }
        return false;
    }

    private void runPcm2MarkovSingle(PCMSolverWorkflowRunConfiguration configuration, UsageScenario scenario, MarkovTransformationSource markovSource, MarkovTransformationResult markovResult) {
        MarkovSolver solver = MarkovSolver.getSingletonInstance();
        boolean countStates = configuration.isPrintMarkovStatistics() && markovResult.getPhysicalStateEvaluationCount() == 0L;
        double physicalStateProbability = 1.0;
        if (configuration.isIterationOverPhysicalSystemStatesEnabled()) {
            for (ProcessingResourceDescriptor descriptor : markovSource.getUnreliableResourceDescriptors()) {
                physicalStateProbability *= descriptor.getStateProbability(descriptor.getCurrentState()).doubleValue();
            }
        }
        MarkovUsageModelVisitor visitor = new MarkovUsageModelVisitor(markovSource, this.getEvaluationMode(configuration), !configuration.isIterationOverPhysicalSystemStatesEnabled(), configuration.isMarkovModelReductionEnabled(), configuration.isMarkovModelTracesEnabled());
        MarkovChain resultChain = (MarkovChain)visitor.doSwitch((EObject)scenario.getScenarioBehaviour_UsageScenario());
        if (countStates) {
            LOGGER.info((Object)("Number of Markov states per evaluated physical system state:\t" + resultChain.getStates().size()));
            LOGGER.info((Object)("Number of Markov transitions per evaluated physical system state:\t" + resultChain.getTransitions().size()));
        }
        double[][] markovProbabilityMatrix = solver.solve(resultChain);
        markovResult.addPhysicalStateResults(resultChain, markovProbabilityMatrix, physicalStateProbability);
    }

    private MarkovTransformationResult runScenarioTransform(PCMInstance model, PCMSolverWorkflowRunConfiguration configuration, UsageScenario scenario) {
        List failureTypes = this.helper.getFailureTypes(this.getEvaluationMode(configuration), model.getRepositories(), model.getResourceEnvironment(), model.getSystem());
        MarkovTransformationSource markovSource = new MarkovTransformationSource(model, true);
        MarkovTransformationResult markovResult = new MarkovTransformationResult(configuration, markovSource, scenario, failureTypes);
        boolean approximate = false;
        try {
            this.runDSolver(scenario, markovSource);
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)("Solving of parametric dependencies caused exception: " + e.getMessage() + " [" + e.getClass() + "]"));
            e.printStackTrace();
            throw e;
        }
        try {
            approximate = this.runPcm2Markov(configuration, scenario, markovSource, markovResult);
        }
        catch (Exception e) {
            LOGGER.error((Object)("PCM 2 Markov transformation caused exception: " + e.getMessage() + " [" + e.getClass() + "]"));
            e.printStackTrace();
        }
        markovResult.setApproximate(approximate);
        return markovResult;
    }

    public List<MarkovTransformationResult> runTransform(PCMInstance model, PCMSolverWorkflowRunConfiguration configuration, MarkovSensitivity sensitivity) {
        if (sensitivity != null) {
            return this.runTransformIteratively(model, configuration, sensitivity);
        }
        return this.runTransformSingle(model, configuration);
    }

    private List<MarkovTransformationResult> runTransformIteratively(PCMInstance model, PCMSolverWorkflowRunConfiguration configuration, MarkovSensitivity sensitivity) {
        int sensitivityStepCount = 0;
        List<MarkovTransformationResult> markovResults = null;
        sensitivity.initialize(model);
        PCMInstance step = sensitivity.getNextModel();
        while (step != null) {
            LOGGER.info((Object)("Starting sensitivity analysis step " + ++sensitivityStepCount + "..."));
            markovResults = this.runTransformSingle(step, configuration);
            sensitivity.logResults(markovResults);
            LOGGER.info((Object)("Sensitivity analysis step " + sensitivityStepCount + " completed"));
            step = sensitivity.getNextModel();
        }
        sensitivity.finalize();
        return markovResults;
    }

    private List<MarkovTransformationResult> runTransformSingle(PCMInstance model, PCMSolverWorkflowRunConfiguration configuration) {
        ArrayList<MarkovTransformationResult> resultList = new ArrayList<MarkovTransformationResult>();
        for (UsageScenario scenario : model.getUsageModel().getUsageScenario_UsageModel()) {
            resultList.add(this.runScenarioTransform(model, configuration, scenario));
        }
        return resultList;
    }
}

